/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.fhir.FhirComponent;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.component.fhir.FhirConsumer;
import org.apache.camel.component.fhir.FhirProducer;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.apache.camel.component.fhir.api.FhirCapabilities;
import org.apache.camel.component.fhir.api.FhirCreate;
import org.apache.camel.component.fhir.api.FhirDelete;
import org.apache.camel.component.fhir.api.FhirHistory;
import org.apache.camel.component.fhir.api.FhirLoadPage;
import org.apache.camel.component.fhir.api.FhirMeta;
import org.apache.camel.component.fhir.api.FhirOperation;
import org.apache.camel.component.fhir.api.FhirPatch;
import org.apache.camel.component.fhir.api.FhirRead;
import org.apache.camel.component.fhir.api.FhirSearch;
import org.apache.camel.component.fhir.api.FhirTransaction;
import org.apache.camel.component.fhir.api.FhirUpdate;
import org.apache.camel.component.fhir.api.FhirValidate;
import org.apache.camel.component.fhir.internal.FhirApiCollection;
import org.apache.camel.component.fhir.internal.FhirApiName;
import org.apache.camel.component.fhir.internal.FhirPropertiesHelper;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.ApiName;

@UriEndpoint(firstVersion="2.23.0", scheme="fhir", title="FHIR", syntax="fhir:apiName/methodName", apiSyntax="apiName/methodName", category={Category.API})
public class FhirEndpoint
extends AbstractApiEndpoint<FhirApiName, FhirConfiguration> {
    private static final String EXTRA_PARAMETERS_PROPERTY = "extraParameters";
    private Object apiProxy;
    @UriParam
    private FhirConfiguration configuration;

    public FhirEndpoint(String uri, FhirComponent component, FhirApiName apiName, String methodName, FhirConfiguration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, FhirApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        return new FhirProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        FhirConsumer consumer = new FhirConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<FhirConfiguration> getPropertiesHelper() {
        return FhirPropertiesHelper.getHelper(this.getCamelContext());
    }

    protected String getThreadProfileName() {
        return "CamelFhir";
    }

    protected void afterConfigureProperties() {
        IGenericClient client = this.getClient();
        switch ((FhirApiName)this.apiName) {
            case CAPABILITIES: {
                this.apiProxy = new FhirCapabilities(client);
                break;
            }
            case CREATE: {
                this.apiProxy = new FhirCreate(client);
                break;
            }
            case DELETE: {
                this.apiProxy = new FhirDelete(client);
                break;
            }
            case HISTORY: {
                this.apiProxy = new FhirHistory(client);
                break;
            }
            case LOAD_PAGE: {
                this.apiProxy = new FhirLoadPage(client);
                break;
            }
            case META: {
                this.apiProxy = new FhirMeta(client);
                break;
            }
            case OPERATION: {
                this.apiProxy = new FhirOperation(client);
                break;
            }
            case PATCH: {
                this.apiProxy = new FhirPatch(client);
                break;
            }
            case READ: {
                this.apiProxy = new FhirRead(client);
                break;
            }
            case SEARCH: {
                this.apiProxy = new FhirSearch(client);
                break;
            }
            case TRANSACTION: {
                this.apiProxy = new FhirTransaction(client);
                break;
            }
            case UPDATE: {
                this.apiProxy = new FhirUpdate(client);
                break;
            }
            case VALIDATE: {
                this.apiProxy = new FhirValidate(client);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid API name " + this.apiName);
            }
        }
    }

    public void interceptProperties(Map<String, Object> properties) {
        Map<ExtraParameters, Object> extraProperties = this.getExtraParameters(properties);
        for (ExtraParameters extraParameter : ExtraParameters.values()) {
            Object value = properties.get(extraParameter.getParam());
            if (value == null) continue;
            extraProperties.put(extraParameter, value);
        }
        properties.put(EXTRA_PARAMETERS_PROPERTY, extraProperties);
    }

    public IGenericClient getClient() {
        return this.configuration.getClient();
    }

    private Map<ExtraParameters, Object> getExtraParameters(Map<String, Object> properties) {
        Object extraParameters = properties.get(EXTRA_PARAMETERS_PROPERTY);
        if (extraParameters == null) {
            return new HashMap<ExtraParameters, Object>();
        }
        return (Map)extraParameters;
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return this.apiProxy;
    }
}

