/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import java.util.List;
import java.util.Map;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;

@ApiParams(apiName="transaction", description="API for sending a transaction (collection of resources) to the server to be executed as a single unit", apiMethods={@ApiMethod(methodName="withBundle", description="Use the given raw text (should be a Bundle resource) as the transaction input", signatures={"org.hl7.fhir.instance.model.api.IBaseBundle withBundle(org.hl7.fhir.instance.model.api.IBaseBundle bundle, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "String withBundle(String stringBundle, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName="withResources", description="Use a list of resources as the transaction input", signatures={"java.util.List<org.hl7.fhir.instance.model.api.IBaseResource> withResources(java.util.List<org.hl7.fhir.instance.model.api.IBaseResource> resources, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"})}, aliases={})
@UriParams
@Configurer(extended=true)
public final class FhirTransactionEndpointConfiguration
extends FhirConfiguration {
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="withBundle", description="Bundle to use in the transaction")})
    private IBaseBundle bundle;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="withBundle", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="withBundle", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="withResources", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL")})
    private Map<ExtraParameters, Object> extraParameters;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="withResources", description="Resources to use in the transaction")})
    private List<IBaseResource> resources;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="withBundle", description="Bundle to use in the transaction")})
    private String stringBundle;

    public IBaseBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(IBaseBundle bundle) {
        this.bundle = bundle;
    }

    public Map<ExtraParameters, Object> getExtraParameters() {
        return this.extraParameters;
    }

    public void setExtraParameters(Map<ExtraParameters, Object> extraParameters) {
        this.extraParameters = extraParameters;
    }

    public List<IBaseResource> getResources() {
        return this.resources;
    }

    public void setResources(List<IBaseResource> resources) {
        this.resources = resources;
    }

    public String getStringBundle() {
        return this.stringBundle;
    }

    public void setStringBundle(String stringBundle) {
        this.stringBundle = stringBundle;
    }
}

