/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.component.fhir.FhirEndpoint;
import org.apache.camel.component.fhir.internal.FhirApiCollection;
import org.apache.camel.component.fhir.internal.FhirApiName;
import org.apache.camel.component.fhir.internal.FhirHelper;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.support.component.ApiCollection;

@Component(value="fhir")
public class FhirComponent
extends AbstractApiComponent<FhirApiName, FhirConfiguration, FhirApiCollection> {
    @Metadata(label="advanced")
    FhirConfiguration configuration;
    @Metadata(label="advanced")
    private IGenericClient client;

    public FhirComponent() {
        super(FhirEndpoint.class, FhirApiName.class, (ApiCollection)FhirApiCollection.getCollection());
    }

    public FhirComponent(CamelContext context) {
        super(context, FhirEndpoint.class, FhirApiName.class, (ApiCollection)FhirApiCollection.getCollection());
    }

    protected FhirApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return FhirApiName.fromValue(apiNameStr);
    }

    protected Endpoint createEndpoint(String uri, String methodName, FhirApiName apiName, FhirConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new FhirEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGenericClient getClient(FhirConfiguration endpointConfiguration) {
        IGenericClient result;
        if (endpointConfiguration.equals(this.configuration)) {
            FhirComponent fhirComponent = this;
            synchronized (fhirComponent) {
                if (this.client == null) {
                    this.client = FhirHelper.createClient(this.configuration, this.getCamelContext());
                }
            }
            result = this.client;
        } else {
            result = FhirHelper.createClient(endpointConfiguration, this.getCamelContext());
        }
        return result;
    }

    public void setConfiguration(FhirConfiguration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public FhirConfiguration getConfiguration() {
        return (FhirConfiguration)super.getConfiguration();
    }
}

