/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import java.util.Map;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IIdType;

@ApiParams(apiName="meta", description="API for the meta operations, which can be used to get, add and remove tags and other Meta elements from a resource or across the server", apiMethods={@ApiMethod(methodName="add", description="Add the elements in the given metadata to the already existing set (do not remove any)", signatures={"org.hl7.fhir.instance.model.api.IBaseMetaType add(org.hl7.fhir.instance.model.api.IBaseMetaType meta, org.hl7.fhir.instance.model.api.IIdType id, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName="delete", description="Delete the elements in the given metadata from the given id", signatures={"org.hl7.fhir.instance.model.api.IBaseMetaType delete(org.hl7.fhir.instance.model.api.IBaseMetaType meta, org.hl7.fhir.instance.model.api.IIdType id, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName="getFromResource", description="Fetch the current metadata from a specific resource", signatures={"org.hl7.fhir.instance.model.api.IBaseMetaType getFromResource(Class<org.hl7.fhir.instance.model.api.IBaseMetaType> metaType, org.hl7.fhir.instance.model.api.IIdType id, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName="getFromServer", description="Fetch the current metadata from the whole Server", signatures={"org.hl7.fhir.instance.model.api.IBaseMetaType getFromServer(Class<org.hl7.fhir.instance.model.api.IBaseMetaType> metaType, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName="getFromType", description="Fetch the current metadata from a specific type", signatures={"org.hl7.fhir.instance.model.api.IBaseMetaType getFromType(Class<org.hl7.fhir.instance.model.api.IBaseMetaType> metaType, String resourceType, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"})}, aliases={})
@UriParams
@Configurer
public final class FhirMetaEndpointConfiguration
extends FhirConfiguration {
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="add", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="delete", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="getFromResource", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="getFromServer", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="getFromType", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL")})
    private Map<ExtraParameters, Object> extraParameters;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="add", description="The id"), @ApiMethod(methodName="delete", description="The id"), @ApiMethod(methodName="getFromResource", description="The id")})
    private IIdType id;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="add", description="The IBaseMetaType class"), @ApiMethod(methodName="delete", description="The IBaseMetaType class")})
    private IBaseMetaType meta;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="getFromResource", description="The IBaseMetaType class"), @ApiMethod(methodName="getFromServer", description="The type of the meta datatype for the given FHIR model version (should be MetaDt.class or MetaType.class)"), @ApiMethod(methodName="getFromType", description="The IBaseMetaType class")})
    private Class<IBaseMetaType> metaType;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="getFromType", description="The resource type e.g Patient")})
    private String resourceType;

    public Map<ExtraParameters, Object> getExtraParameters() {
        return this.extraParameters;
    }

    public void setExtraParameters(Map<ExtraParameters, Object> extraParameters) {
        this.extraParameters = extraParameters;
    }

    public IIdType getId() {
        return this.id;
    }

    public void setId(IIdType id) {
        this.id = id;
    }

    public IBaseMetaType getMeta() {
        return this.meta;
    }

    public void setMeta(IBaseMetaType meta) {
        this.meta = meta;
    }

    public Class<IBaseMetaType> getMetaType() {
        return this.metaType;
    }

    public void setMetaType(Class<IBaseMetaType> metaType) {
        this.metaType = metaType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }
}

