/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.fhir.api.FhirMeta;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IIdType;

public enum FhirMetaApiMethod implements ApiMethod
{
    ADD(IBaseMetaType.class, "add", ApiMethodArg.arg((String)"meta", IBaseMetaType.class), ApiMethodArg.arg((String)"id", IIdType.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    DELETE(IBaseMetaType.class, "delete", ApiMethodArg.arg((String)"meta", IBaseMetaType.class), ApiMethodArg.arg((String)"id", IIdType.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    GET_FROM_RESOURCE(IBaseMetaType.class, "getFromResource", ApiMethodArg.arg((String)"metaType", Class.class), ApiMethodArg.arg((String)"id", IIdType.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    GET_FROM_SERVER(IBaseMetaType.class, "getFromServer", ApiMethodArg.arg((String)"metaType", Class.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    GET_FROM_TYPE(IBaseMetaType.class, "getFromType", ApiMethodArg.arg((String)"metaType", Class.class), ApiMethodArg.arg((String)"resourceType", String.class), ApiMethodArg.arg((String)"extraParameters", Map.class));

    private final ApiMethod apiMethod;

    private FhirMetaApiMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
        this.apiMethod = new ApiMethodImpl(FhirMeta.class, resultType, name, args);
    }

    public String getName() {
        return this.apiMethod.getName();
    }

    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    public List<String> getSetterArgNames() {
        return this.apiMethod.getSetterArgNames();
    }

    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

