/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.watch;

import org.apache.camel.spi.Metadata;

public final class FileWatchConstants {
    @Metadata(description="Type of event. Possible values: CREATE, DELETE, MODIFY.", javaType="String")
    public static final String EVENT_TYPE_HEADER = "CamelFileEventType";
    @Metadata(description="Only the file name (the name with no leading paths).", javaType="String")
    public static final String FILE_NAME_ONLY = "CamelFileNameOnly";
    @Metadata(description="A `boolean` option specifying whether the consumed file denotes an\nabsolute path or not. Should normally be `false` for relative paths.\nAbsolute paths should normally not be used but we added to the move\noption to allow moving files to absolute paths. But can be used\nelsewhere as well.", javaType="Boolean")
    public static final String FILE_ABSOLUTE = "CamelFileAbsolute";
    @Metadata(description="The absolute path to the file. For relative files this path holds the\nrelative path instead.", javaType="String")
    public static final String FILE_ABSOLUTE_PATH = "CamelFileAbsolutePath";
    @Metadata(description="The file path. For relative files this is the starting directory + the\nrelative filename. For absolute files this is the absolute path.", javaType="String")
    public static final String FILE_PATH = "CamelFilePath";
    @Metadata(description="Name of the consumed file as a relative file path with offset from the\nstarting directory configured on the endpoint.", javaType="String")
    public static final String FILE_NAME = "CamelFileName";
    @Metadata(description="The relative path.", javaType="String")
    public static final String FILE_RELATIVE_PATH = "CamelFileRelativePath";
    @Metadata(description="The name of the file that has been consumed", javaType="String")
    public static final String FILE_NAME_CONSUMED = "CamelFileNameConsumed";
    @Metadata(description="The parent path.", javaType="String")
    public static final String FILE_PARENT = "CamelFileParent";
    @Metadata(description="A `Long` value containing the last modified timestamp of the file.", javaType="long")
    public static final String FILE_LAST_MODIFIED = "CamelFileLastModified";

    private FileWatchConstants() {
    }
}

