/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.file.AntPathMatcherGenericFileFilter;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileDefaultSorter;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.strategy.FileMoveExistingStrategy;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericFileEndpoint<T>
extends ScheduledPollEndpoint
implements BrowsableEndpoint {
    protected static final String DEFAULT_STRATEGYFACTORY_CLASS = "org.apache.camel.component.file.strategy.GenericFileProcessStrategyFactory";
    protected static final int DEFAULT_IDEMPOTENT_CACHE_SIZE = 1000;
    protected static final int DEFAULT_IN_PROGRESS_CACHE_SIZE = 50000;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @UriParam(label="advanced", defaultValue="true")
    protected boolean autoCreate = true;
    @UriParam(label="advanced", defaultValue="131072")
    protected int bufferSize = 131072;
    @UriParam
    protected String charset;
    @UriParam(javaType="java.lang.String")
    protected Expression fileName;
    @UriParam
    protected String doneFileName;
    @UriParam(label="producer")
    protected boolean flatten;
    @UriParam(label="producer", defaultValue="Override")
    protected GenericFileExist fileExist = GenericFileExist.Override;
    @UriParam(label="producer")
    protected String tempPrefix;
    @UriParam(label="producer", javaType="java.lang.String")
    protected Expression tempFileName;
    @UriParam(label="producer,advanced", defaultValue="true")
    protected boolean eagerDeleteTargetFile = true;
    @UriParam(label="producer,advanced")
    protected boolean keepLastModified;
    @UriParam(label="producer,advanced")
    protected boolean allowNullBody;
    @UriParam(label="producer", defaultValue="true")
    protected boolean jailStartingDirectory = true;
    @UriParam
    protected GenericFileConfiguration configuration;
    @UriParam(label="consumer,advanced")
    protected GenericFileProcessStrategy<T> processStrategy;
    @UriParam(label="consumer,advanced")
    protected IdempotentRepository inProgressRepository = MemoryIdempotentRepository.memoryIdempotentRepository((int)50000);
    @UriParam(label="consumer,advanced")
    protected String localWorkDirectory;
    @UriParam(label="consumer")
    protected boolean noop;
    @UriParam(label="consumer")
    protected boolean recursive;
    @UriParam(label="consumer")
    protected boolean delete;
    @UriParam(label="consumer")
    protected boolean preSort;
    @UriParam(label="consumer,filter")
    protected int maxMessagesPerPoll;
    @UriParam(label="consumer,filter", defaultValue="true")
    protected boolean eagerMaxMessagesPerPoll = true;
    @UriParam(label="consumer,filter", defaultValue="2147483647")
    protected int maxDepth = Integer.MAX_VALUE;
    @UriParam(label="consumer,filter")
    protected int minDepth;
    @UriParam(label="consumer,filter")
    protected String include;
    @UriParam(label="consumer,filter")
    protected String exclude;
    @UriParam(label="consumer,filter", javaType="java.lang.String")
    protected Expression move;
    @UriParam(label="consumer", javaType="java.lang.String")
    protected Expression moveFailed;
    @UriParam(label="consumer", javaType="java.lang.String")
    protected Expression preMove;
    @UriParam(label="producer", javaType="java.lang.String")
    protected Expression moveExisting;
    @UriParam(label="producer,advanced")
    protected FileMoveExistingStrategy moveExistingFileStrategy;
    @UriParam(label="consumer,filter", defaultValue="false")
    protected Boolean idempotent;
    @UriParam(label="consumer,filter", javaType="java.lang.String")
    protected Expression idempotentKey;
    @UriParam(label="consumer,filter")
    protected IdempotentRepository idempotentRepository;
    @UriParam(label="consumer,filter")
    protected GenericFileFilter<T> filter;
    @UriParam(label="consumer,filter", javaType="java.lang.String")
    protected Predicate filterDirectory;
    @UriParam(label="consumer,filter", javaType="java.lang.String")
    protected Predicate filterFile;
    @UriParam(label="consumer,filter", defaultValue="true")
    protected boolean antFilterCaseSensitive = true;
    protected volatile AntPathMatcherGenericFileFilter<T> antFilter;
    @UriParam(label="consumer,filter")
    protected String antInclude;
    @UriParam(label="consumer,filter")
    protected String antExclude;
    @UriParam(label="consumer,sort")
    protected Comparator<GenericFile<T>> sorter;
    @UriParam(label="consumer,sort", javaType="java.lang.String")
    protected Comparator<Exchange> sortBy;
    @UriParam(label="consumer,sort")
    protected boolean shuffle;
    @UriParam(label="consumer,lock", defaultValue="none", enums="none,markerFile,fileLock,rename,changed,idempotent,idempotent-changed,idempotent-rename")
    protected String readLock = "none";
    @UriParam(label="consumer,lock", defaultValue="1000")
    protected long readLockCheckInterval = 1000L;
    @UriParam(label="consumer,lock", defaultValue="10000")
    protected long readLockTimeout = 10000L;
    @UriParam(label="consumer,lock", defaultValue="true")
    protected boolean readLockMarkerFile = true;
    @UriParam(label="consumer,lock", defaultValue="true")
    protected boolean readLockDeleteOrphanLockFiles = true;
    @UriParam(label="consumer,lock", defaultValue="DEBUG")
    protected LoggingLevel readLockLoggingLevel = LoggingLevel.DEBUG;
    @UriParam(label="consumer,lock", defaultValue="1")
    protected long readLockMinLength = 1L;
    @UriParam(label="consumer,lock", defaultValue="0")
    protected long readLockMinAge;
    @UriParam(label="consumer,lock", defaultValue="true")
    protected boolean readLockRemoveOnRollback = true;
    @UriParam(label="consumer,lock")
    protected boolean readLockRemoveOnCommit;
    @UriParam(label="consumer,lock")
    protected int readLockIdempotentReleaseDelay;
    @UriParam(label="consumer,lock")
    protected boolean readLockIdempotentReleaseAsync;
    @UriParam(label="consumer,lock")
    protected int readLockIdempotentReleaseAsyncPoolSize;
    @UriParam(label="consumer,lock")
    protected ScheduledExecutorService readLockIdempotentReleaseExecutorService;
    @UriParam(label="consumer,lock")
    protected GenericFileExclusiveReadLockStrategy<T> exclusiveReadLockStrategy;
    @UriParam(label="consumer,advanced")
    protected ExceptionHandler onCompletionExceptionHandler;
    private Pattern includePattern;
    private Pattern excludePattern;

    public GenericFileEndpoint() {
    }

    public GenericFileEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public abstract GenericFileConsumer<T> createConsumer(Processor var1) throws Exception;

    public abstract GenericFileProducer<T> createProducer() throws Exception;

    public abstract Exchange createExchange(GenericFile<T> var1);

    public abstract String getScheme();

    public abstract char getFileSeparator();

    public abstract boolean isAbsolute(String var1);

    public String getGeneratedFileName(Message message) {
        return StringHelper.sanitize((String)message.getMessageId());
    }

    public List<Exchange> getExchanges() {
        final ArrayList<Exchange> answer = new ArrayList<Exchange>();
        GenericFileConsumer<T> consumer = null;
        try {
            consumer = this.createConsumer(null);
            consumer.setCustomProcessor(new Processor(){

                public void process(Exchange exchange) throws Exception {
                    answer.add(exchange);
                }
            });
            consumer.setStartScheduler(false);
            ServiceHelper.startService(consumer);
            consumer.poll();
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        finally {
            try {
                ServiceHelper.stopService(consumer);
            }
            catch (Exception e) {
                this.log.debug("Error stopping consumer used for browsing exchanges. This exception will be ignored", (Throwable)e);
            }
        }
        return answer;
    }

    protected GenericFileProcessStrategy<T> createGenericFileStrategy() {
        Class factory = null;
        try {
            FactoryFinder finder = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getFactoryFinder("META-INF/services/org/apache/camel/component/");
            this.log.trace("Using FactoryFinder: {}", (Object)finder);
            factory = finder.findClass(this.getScheme(), "strategy.factory.", CamelContext.class);
        }
        catch (ClassNotFoundException e) {
            this.log.trace("'strategy.factory.class' not found", (Throwable)e);
        }
        catch (IOException e) {
            this.log.trace("No strategy factory defined in 'META-INF/services/org/apache/camel/component/'", (Throwable)e);
        }
        if (factory == null) {
            block12: {
                try {
                    this.log.trace("Using ClassResolver to resolve class: {}", (Object)DEFAULT_STRATEGYFACTORY_CLASS);
                    factory = this.getCamelContext().getClassResolver().resolveClass(DEFAULT_STRATEGYFACTORY_CLASS);
                }
                catch (Exception e) {
                    this.log.trace("Cannot load class: {}", (Object)DEFAULT_STRATEGYFACTORY_CLASS, (Object)e);
                }
                try {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Using classloader: {} to resolve class: {}", (Object)((Object)((Object)this)).getClass().getClassLoader(), (Object)DEFAULT_STRATEGYFACTORY_CLASS);
                    }
                    factory = this.getCamelContext().getClassResolver().resolveClass(DEFAULT_STRATEGYFACTORY_CLASS, ((Object)((Object)this)).getClass().getClassLoader());
                }
                catch (Exception e) {
                    if (!this.log.isTraceEnabled()) break block12;
                    this.log.trace("Cannot load class: {} using classloader: " + ((Object)((Object)this)).getClass().getClassLoader(), (Object)DEFAULT_STRATEGYFACTORY_CLASS, (Object)e);
                }
            }
            if (factory == null) {
                throw new TypeNotPresentException("org.apache.camel.component.file.strategy.GenericFileProcessStrategyFactory class not found", null);
            }
        }
        try {
            Method factoryMethod = factory.getMethod("createGenericFileProcessStrategy", CamelContext.class, Map.class);
            Map<String, Object> params = this.getParamsAsMap();
            this.log.debug("Parameters for Generic file process strategy {}", params);
            return (GenericFileProcessStrategy)ObjectHelper.invokeMethod((Method)factoryMethod, null, (Object[])new Object[]{this.getCamelContext(), params});
        }
        catch (NoSuchMethodException e) {
            throw new TypeNotPresentException(factory.getSimpleName() + ".createGenericFileProcessStrategy method not found", e);
        }
    }

    public boolean isNoop() {
        return this.noop;
    }

    public void setNoop(boolean noop) {
        this.noop = noop;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
        this.includePattern = Pattern.compile(include, 2);
    }

    public Pattern getIncludePattern() {
        return this.includePattern;
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
        this.excludePattern = Pattern.compile(exclude, 2);
    }

    public Pattern getExcludePattern() {
        return this.excludePattern;
    }

    public String getAntInclude() {
        return this.antInclude;
    }

    public void setAntInclude(String antInclude) {
        this.antInclude = antInclude;
    }

    public String getAntExclude() {
        return this.antExclude;
    }

    public void setAntExclude(String antExclude) {
        this.antExclude = antExclude;
    }

    public boolean isAntFilterCaseSensitive() {
        return this.antFilterCaseSensitive;
    }

    public void setAntFilterCaseSensitive(boolean antFilterCaseSensitive) {
        this.antFilterCaseSensitive = antFilterCaseSensitive;
    }

    public GenericFileFilter<T> getAntFilter() {
        return this.antFilter;
    }

    public boolean isPreSort() {
        return this.preSort;
    }

    public void setPreSort(boolean preSort) {
        this.preSort = preSort;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public Expression getMove() {
        return this.move;
    }

    public void setMove(Expression move) {
        this.move = move;
    }

    public void setMove(String fileLanguageExpression) {
        String expression = this.configureMoveOrPreMoveExpression(fileLanguageExpression);
        this.move = this.createFileLanguageExpression(expression);
    }

    public Expression getMoveFailed() {
        return this.moveFailed;
    }

    public void setMoveFailed(Expression moveFailed) {
        this.moveFailed = moveFailed;
    }

    public void setMoveFailed(String fileLanguageExpression) {
        String expression = this.configureMoveOrPreMoveExpression(fileLanguageExpression);
        this.moveFailed = this.createFileLanguageExpression(expression);
    }

    public Predicate getFilterDirectory() {
        return this.filterDirectory;
    }

    public void setFilterDirectory(Predicate filterDirectory) {
        this.filterDirectory = filterDirectory;
    }

    public void setFilterDirectory(String expression) {
        this.filterDirectory = this.createFileLanguagePredicate(expression);
    }

    public Predicate getFilterFile() {
        return this.filterFile;
    }

    public void setFilterFile(Predicate filterFile) {
        this.filterFile = filterFile;
    }

    public void setFilterFile(String expression) {
        this.filterFile = this.createFileLanguagePredicate(expression);
    }

    public Expression getPreMove() {
        return this.preMove;
    }

    public void setPreMove(Expression preMove) {
        this.preMove = preMove;
    }

    public void setPreMove(String fileLanguageExpression) {
        String expression = this.configureMoveOrPreMoveExpression(fileLanguageExpression);
        this.preMove = this.createFileLanguageExpression(expression);
    }

    public Expression getMoveExisting() {
        return this.moveExisting;
    }

    public void setMoveExisting(Expression moveExisting) {
        this.moveExisting = moveExisting;
    }

    public FileMoveExistingStrategy getMoveExistingFileStrategy() {
        return this.moveExistingFileStrategy;
    }

    public void setMoveExistingFileStrategy(FileMoveExistingStrategy moveExistingFileStrategy) {
        this.moveExistingFileStrategy = moveExistingFileStrategy;
    }

    public void setMoveExisting(String fileLanguageExpression) {
        String expression = this.configureMoveOrPreMoveExpression(fileLanguageExpression);
        this.moveExisting = this.createFileLanguageExpression(expression);
    }

    public Expression getFileName() {
        return this.fileName;
    }

    public void setFileName(Expression fileName) {
        this.fileName = fileName;
    }

    public void setFileName(String fileLanguageExpression) {
        this.fileName = this.createFileLanguageExpression(fileLanguageExpression);
    }

    public String getDoneFileName() {
        return this.doneFileName;
    }

    public void setDoneFileName(String doneFileName) {
        this.doneFileName = doneFileName;
    }

    public Boolean isIdempotent() {
        return this.idempotent != null ? this.idempotent : false;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        IOHelper.validateCharset((String)charset);
        this.charset = charset;
    }

    protected boolean isIdempotentSet() {
        return this.idempotent != null;
    }

    public void setIdempotent(Boolean idempotent) {
        this.idempotent = idempotent;
    }

    public Expression getIdempotentKey() {
        return this.idempotentKey;
    }

    public void setIdempotentKey(Expression idempotentKey) {
        this.idempotentKey = idempotentKey;
    }

    public void setIdempotentKey(String expression) {
        this.idempotentKey = this.createFileLanguageExpression(expression);
    }

    public IdempotentRepository getIdempotentRepository() {
        return this.idempotentRepository;
    }

    public void setIdempotentRepository(IdempotentRepository idempotentRepository) {
        this.idempotentRepository = idempotentRepository;
    }

    public GenericFileFilter<T> getFilter() {
        return this.filter;
    }

    public void setFilter(GenericFileFilter<T> filter) {
        this.filter = filter;
    }

    public Comparator<GenericFile<T>> getSorter() {
        return this.sorter;
    }

    public void setSorter(Comparator<GenericFile<T>> sorter) {
        this.sorter = sorter;
    }

    public Comparator<Exchange> getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(Comparator<Exchange> sortBy) {
        this.sortBy = sortBy;
    }

    public void setSortBy(String expression) {
        this.setSortBy(expression, false);
    }

    public void setSortBy(String expression, boolean reverse) {
        this.setSortBy(GenericFileDefaultSorter.sortByFileLanguage(this.getCamelContext(), expression, reverse));
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public String getTempPrefix() {
        return this.tempPrefix;
    }

    public void setTempPrefix(String tempPrefix) {
        this.tempPrefix = tempPrefix;
        this.setTempFileName(tempPrefix + "${file:onlyname}");
    }

    public Expression getTempFileName() {
        return this.tempFileName;
    }

    public void setTempFileName(Expression tempFileName) {
        this.tempFileName = tempFileName;
    }

    public void setTempFileName(String tempFileNameExpression) {
        this.tempFileName = this.createFileLanguageExpression(tempFileNameExpression);
    }

    public boolean isEagerDeleteTargetFile() {
        return this.eagerDeleteTargetFile;
    }

    public void setEagerDeleteTargetFile(boolean eagerDeleteTargetFile) {
        this.eagerDeleteTargetFile = eagerDeleteTargetFile;
    }

    public GenericFileConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new GenericFileConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(GenericFileConfiguration configuration) {
        this.configuration = configuration;
    }

    public GenericFileExclusiveReadLockStrategy<T> getExclusiveReadLockStrategy() {
        return this.exclusiveReadLockStrategy;
    }

    public void setExclusiveReadLockStrategy(GenericFileExclusiveReadLockStrategy<T> exclusiveReadLockStrategy) {
        this.exclusiveReadLockStrategy = exclusiveReadLockStrategy;
    }

    public String getReadLock() {
        return this.readLock;
    }

    public void setReadLock(String readLock) {
        this.readLock = readLock;
    }

    public long getReadLockCheckInterval() {
        return this.readLockCheckInterval;
    }

    public void setReadLockCheckInterval(long readLockCheckInterval) {
        this.readLockCheckInterval = readLockCheckInterval;
    }

    public long getReadLockTimeout() {
        return this.readLockTimeout;
    }

    public void setReadLockTimeout(long readLockTimeout) {
        this.readLockTimeout = readLockTimeout;
    }

    public boolean isReadLockMarkerFile() {
        return this.readLockMarkerFile;
    }

    public void setReadLockMarkerFile(boolean readLockMarkerFile) {
        this.readLockMarkerFile = readLockMarkerFile;
    }

    public boolean isReadLockDeleteOrphanLockFiles() {
        return this.readLockDeleteOrphanLockFiles;
    }

    public void setReadLockDeleteOrphanLockFiles(boolean readLockDeleteOrphanLockFiles) {
        this.readLockDeleteOrphanLockFiles = readLockDeleteOrphanLockFiles;
    }

    public LoggingLevel getReadLockLoggingLevel() {
        return this.readLockLoggingLevel;
    }

    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        this.readLockLoggingLevel = readLockLoggingLevel;
    }

    public long getReadLockMinLength() {
        return this.readLockMinLength;
    }

    public void setReadLockMinLength(long readLockMinLength) {
        this.readLockMinLength = readLockMinLength;
    }

    public long getReadLockMinAge() {
        return this.readLockMinAge;
    }

    public void setReadLockMinAge(long readLockMinAge) {
        this.readLockMinAge = readLockMinAge;
    }

    public boolean isReadLockRemoveOnRollback() {
        return this.readLockRemoveOnRollback;
    }

    public void setReadLockRemoveOnRollback(boolean readLockRemoveOnRollback) {
        this.readLockRemoveOnRollback = readLockRemoveOnRollback;
    }

    public boolean isReadLockRemoveOnCommit() {
        return this.readLockRemoveOnCommit;
    }

    public void setReadLockRemoveOnCommit(boolean readLockRemoveOnCommit) {
        this.readLockRemoveOnCommit = readLockRemoveOnCommit;
    }

    public void setReadLockIdempotentReleaseDelay(int readLockIdempotentReleaseDelay) {
        this.readLockIdempotentReleaseDelay = readLockIdempotentReleaseDelay;
    }

    public boolean isReadLockIdempotentReleaseAsync() {
        return this.readLockIdempotentReleaseAsync;
    }

    public void setReadLockIdempotentReleaseAsync(boolean readLockIdempotentReleaseAsync) {
        this.readLockIdempotentReleaseAsync = readLockIdempotentReleaseAsync;
    }

    public int getReadLockIdempotentReleaseAsyncPoolSize() {
        return this.readLockIdempotentReleaseAsyncPoolSize;
    }

    public void setReadLockIdempotentReleaseAsyncPoolSize(int readLockIdempotentReleaseAsyncPoolSize) {
        this.readLockIdempotentReleaseAsyncPoolSize = readLockIdempotentReleaseAsyncPoolSize;
    }

    public ScheduledExecutorService getReadLockIdempotentReleaseExecutorService() {
        return this.readLockIdempotentReleaseExecutorService;
    }

    public void setReadLockIdempotentReleaseExecutorService(ScheduledExecutorService readLockIdempotentReleaseExecutorService) {
        this.readLockIdempotentReleaseExecutorService = readLockIdempotentReleaseExecutorService;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("BufferSize must be a positive value, was " + bufferSize);
        }
        this.bufferSize = bufferSize;
    }

    public GenericFileExist getFileExist() {
        return this.fileExist;
    }

    public void setFileExist(GenericFileExist fileExist) {
        this.fileExist = fileExist;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public GenericFileProcessStrategy<T> getProcessStrategy() {
        return this.processStrategy;
    }

    public void setProcessStrategy(GenericFileProcessStrategy<T> processStrategy) {
        this.processStrategy = processStrategy;
    }

    public String getLocalWorkDirectory() {
        return this.localWorkDirectory;
    }

    public void setLocalWorkDirectory(String localWorkDirectory) {
        this.localWorkDirectory = localWorkDirectory;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public boolean isEagerMaxMessagesPerPoll() {
        return this.eagerMaxMessagesPerPoll;
    }

    public void setEagerMaxMessagesPerPoll(boolean eagerMaxMessagesPerPoll) {
        this.eagerMaxMessagesPerPoll = eagerMaxMessagesPerPoll;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public void setMinDepth(int minDepth) {
        this.minDepth = minDepth;
    }

    public IdempotentRepository getInProgressRepository() {
        return this.inProgressRepository;
    }

    public void setInProgressRepository(IdempotentRepository inProgressRepository) {
        this.inProgressRepository = inProgressRepository;
    }

    public boolean isKeepLastModified() {
        return this.keepLastModified;
    }

    public void setKeepLastModified(boolean keepLastModified) {
        this.keepLastModified = keepLastModified;
    }

    public boolean isAllowNullBody() {
        return this.allowNullBody;
    }

    public void setAllowNullBody(boolean allowNullBody) {
        this.allowNullBody = allowNullBody;
    }

    public boolean isJailStartingDirectory() {
        return this.jailStartingDirectory;
    }

    public void setJailStartingDirectory(boolean jailStartingDirectory) {
        this.jailStartingDirectory = jailStartingDirectory;
    }

    public ExceptionHandler getOnCompletionExceptionHandler() {
        return this.onCompletionExceptionHandler;
    }

    public void setOnCompletionExceptionHandler(ExceptionHandler onCompletionExceptionHandler) {
        this.onCompletionExceptionHandler = onCompletionExceptionHandler;
    }

    public void configureMessage(GenericFile<T> file, Message message) {
        message.setBody(file);
        if (this.flatten) {
            message.setHeader("CamelFileName", (Object)file.getFileNameOnly());
        } else {
            String name = file.isAbsolute() ? file.getAbsoluteFilePath() : file.getRelativeFilePath();
            String endpointPath = this.getConfiguration().getDirectory() + this.getFileSeparator();
            endpointPath = FileUtil.normalizePath((String)endpointPath);
            String copyOfName = FileUtil.normalizePath((String)name);
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)endpointPath) && copyOfName.startsWith(endpointPath)) {
                name = name.substring(endpointPath.length());
            }
            message.setHeader("CamelFileName", (Object)name);
        }
    }

    public void configureExchange(Exchange exchange) {
        if (this.getCharset() != null) {
            exchange.setProperty("CamelCharsetName", (Object)this.getCharset());
        }
    }

    protected String configureMoveOrPreMoveExpression(String expression) {
        if (StringHelper.hasStartToken((String)expression, (String)"simple")) {
            return expression;
        }
        expression = FileUtil.stripTrailingSeparator((String)expression);
        StringBuilder sb = new StringBuilder();
        if (!this.isAbsolute(expression)) {
            sb.append("${file:parent}");
            sb.append(this.getFileSeparator());
        }
        sb.append(expression);
        sb.append(this.getFileSeparator());
        sb.append("${file:onlyname}");
        return sb.toString();
    }

    protected Map<String, Object> getParamsAsMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.isNoop()) {
            params.put("noop", Boolean.toString(true));
        }
        if (this.isDelete()) {
            params.put("delete", Boolean.toString(true));
        }
        if (this.move != null) {
            params.put("move", this.move);
        }
        if (this.moveFailed != null) {
            params.put("moveFailed", this.moveFailed);
        }
        if (this.preMove != null) {
            params.put("preMove", this.preMove);
        }
        if (this.exclusiveReadLockStrategy != null) {
            params.put("exclusiveReadLockStrategy", this.exclusiveReadLockStrategy);
        }
        if (this.readLock != null) {
            params.put("readLock", this.readLock);
        }
        if ("idempotent".equals(this.readLock) || "idempotent-changed".equals(this.readLock) || "idempotent-rename".equals(this.readLock)) {
            params.put("readLockIdempotentRepository", this.idempotentRepository);
        }
        if (this.readLockCheckInterval > 0L) {
            params.put("readLockCheckInterval", this.readLockCheckInterval);
        }
        if (this.readLockTimeout > 0L) {
            params.put("readLockTimeout", this.readLockTimeout);
        }
        params.put("readLockMarkerFile", this.readLockMarkerFile);
        params.put("readLockDeleteOrphanLockFiles", this.readLockDeleteOrphanLockFiles);
        params.put("readLockMinLength", this.readLockMinLength);
        params.put("readLockLoggingLevel", this.readLockLoggingLevel);
        params.put("readLockMinAge", this.readLockMinAge);
        params.put("readLockRemoveOnRollback", this.readLockRemoveOnRollback);
        params.put("readLockRemoveOnCommit", this.readLockRemoveOnCommit);
        if (this.readLockIdempotentReleaseDelay > 0) {
            params.put("readLockIdempotentReleaseDelay", this.readLockIdempotentReleaseDelay);
        }
        params.put("readLockIdempotentReleaseAsync", this.readLockIdempotentReleaseAsync);
        if (this.readLockIdempotentReleaseAsyncPoolSize > 0) {
            params.put("readLockIdempotentReleaseAsyncPoolSize", this.readLockIdempotentReleaseAsyncPoolSize);
        }
        if (this.readLockIdempotentReleaseExecutorService != null) {
            params.put("readLockIdempotentReleaseExecutorService", this.readLockIdempotentReleaseExecutorService);
        }
        return params;
    }

    private Expression createFileLanguageExpression(String expression) {
        Language language = expression.contains("$") ? this.getCamelContext().resolveLanguage("file") : this.getCamelContext().resolveLanguage("constant");
        return language.createExpression(expression);
    }

    private Predicate createFileLanguagePredicate(String expression) {
        Language language = this.getCamelContext().resolveLanguage("file");
        return language.createPredicate(expression);
    }

    protected String createDoneFileName(String fileName) {
        String pattern = this.getDoneFileName();
        StringHelper.notEmpty((String)pattern, (String)"doneFileName", (Object)pattern);
        String path = FileUtil.onlyPath((String)fileName);
        String onlyName = Matcher.quoteReplacement(FileUtil.stripPath((String)fileName));
        pattern = pattern.replaceFirst("\\$\\{file:name\\}", onlyName);
        pattern = pattern.replaceFirst("\\$simple\\{file:name\\}", onlyName);
        pattern = pattern.replaceFirst("\\$\\{file:name.noext\\}", FileUtil.stripExt((String)onlyName, (boolean)true));
        pattern = pattern.replaceFirst("\\$simple\\{file:name.noext\\}", FileUtil.stripExt((String)onlyName, (boolean)true));
        if (StringHelper.hasStartToken((String)pattern, (String)"simple")) {
            throw new ExpressionIllegalSyntaxException(fileName + ". Cannot resolve reminder: " + pattern);
        }
        String answer = pattern;
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)path) && org.apache.camel.util.ObjectHelper.isNotEmpty((Object)pattern)) {
            answer = path + this.getFileSeparator() + pattern;
        }
        if (this.getConfiguration().needToNormalize()) {
            answer = FileUtil.normalizePath((String)answer);
        }
        return answer;
    }

    protected boolean isDoneFile(String fileName) {
        String pattern = this.getDoneFileName();
        StringHelper.notEmpty((String)pattern, (String)"doneFileName", (Object)pattern);
        if (!StringHelper.hasStartToken((String)pattern, (String)"simple")) {
            return pattern.equals(fileName);
        }
        boolean prefix = pattern.indexOf("${") > 0;
        pattern = pattern.replaceFirst("\\$\\{file:name\\}", "");
        pattern = pattern.replaceFirst("\\$simple\\{file:name\\}", "");
        pattern = pattern.replaceFirst("\\$\\{file:name.noext\\}", "");
        if (StringHelper.hasStartToken((String)(pattern = pattern.replaceFirst("\\$simple\\{file:name.noext\\}", "")), (String)"simple")) {
            throw new ExpressionIllegalSyntaxException(fileName + ". Cannot resolve reminder: " + pattern);
        }
        if (prefix) {
            return fileName.startsWith(pattern);
        }
        return fileName.endsWith(pattern);
    }

    protected void doStart() throws Exception {
        if (!"none".equals(this.readLock) && !"off".equals(this.readLock) && this.readLockTimeout > 0L && this.readLockTimeout <= this.readLockCheckInterval) {
            throw new IllegalArgumentException("The option readLockTimeout must be higher than readLockCheckInterval, was readLockTimeout=" + this.readLockTimeout + ", readLockCheckInterval=" + this.readLockCheckInterval + ". A good practice is to let the readLockTimeout be at least 3 times higher than the readLockCheckInterval to ensure that the read lock procedure has enough time to acquire the lock.");
        }
        if ("idempotent".equals(this.readLock) && this.idempotentRepository == null) {
            throw new IllegalArgumentException("IdempotentRepository must be configured when using readLock=idempotent");
        }
        if ("fileLock".equals(this.readLock) && FileUtil.isWindows()) {
            throw new IllegalArgumentException("The readLock=fileLock option is not supported on Windows");
        }
        if (this.antInclude != null) {
            if (this.antFilter == null) {
                this.antFilter = new AntPathMatcherGenericFileFilter();
            }
            this.antFilter.setIncludes(this.antInclude);
        }
        if (this.antExclude != null) {
            if (this.antFilter == null) {
                this.antFilter = new AntPathMatcherGenericFileFilter();
            }
            this.antFilter.setExcludes(this.antExclude);
        }
        if (this.antFilter != null) {
            this.antFilter.setCaseSensitive(this.antFilterCaseSensitive);
        }
        if (this.idempotentRepository != null) {
            this.getCamelContext().addService((Object)this.idempotentRepository, true);
        }
        ServiceHelper.startService((Object)this.inProgressRepository);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.inProgressRepository);
    }
}

