/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class FileEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":directoryName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "file".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "directoryName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(94);
        props.add("renameUsingCopy");
        props.add("moveExistingFileStrategy");
        props.add("fileName");
        props.add("antInclude");
        props.add("synchronous");
        props.add("moveExisting");
        props.add("initialDelay");
        props.add("flatten");
        props.add("idempotent");
        props.add("bridgeErrorHandler");
        props.add("eagerDeleteTargetFile");
        props.add("readLockRemoveOnRollback");
        props.add("readLockRemoveOnCommit");
        props.add("preSort");
        props.add("greedy");
        props.add("exclude");
        props.add("maxMessagesPerPoll");
        props.add("readLockIdempotentReleaseDelay");
        props.add("sortBy");
        props.add("scheduledExecutorService");
        props.add("directoryName");
        props.add("readLockIdempotentReleaseExecutorService");
        props.add("repeatCount");
        props.add("readLockDeleteOrphanLockFiles");
        props.add("probeContentType");
        props.add("sendEmptyMessageWhenIdle");
        props.add("processStrategy");
        props.add("readLock");
        props.add("schedulerProperties");
        props.add("inProgressRepository");
        props.add("readLockLoggingLevel");
        props.add("backoffIdleThreshold");
        props.add("readLockMinLength");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("startScheduler");
        props.add("readLockMarkerFile");
        props.add("readLockTimeout");
        props.add("exceptionHandler");
        props.add("eagerMaxMessagesPerPoll");
        props.add("backoffMultiplier");
        props.add("charset");
        props.add("startingDirectoryMustHaveAccess");
        props.add("idempotentKey");
        props.add("exclusiveReadLockStrategy");
        props.add("readLockCheckInterval");
        props.add("sorter");
        props.add("fileExist");
        props.add("copyAndDeleteOnRenameFail");
        props.add("localWorkDirectory");
        props.add("startingDirectoryMustExist");
        props.add("directoryMustExist");
        props.add("autoCreate");
        props.add("includeExt");
        props.add("readLockIdempotentReleaseAsyncPoolSize");
        props.add("delete");
        props.add("readLockMinAge");
        props.add("recursive");
        props.add("extendedAttributes");
        props.add("antExclude");
        props.add("keepLastModified");
        props.add("scheduler");
        props.add("noop");
        props.add("useFixedDelay");
        props.add("jailStartingDirectory");
        props.add("doneFileName");
        props.add("runLoggingLevel");
        props.add("backoffErrorThreshold");
        props.add("chmod");
        props.add("onCompletionExceptionHandler");
        props.add("tempPrefix");
        props.add("allowNullBody");
        props.add("timeUnit");
        props.add("appendChars");
        props.add("minDepth");
        props.add("include");
        props.add("moveFailed");
        props.add("preMove");
        props.add("move");
        props.add("idempotentRepository");
        props.add("readLockIdempotentReleaseAsync");
        props.add("exchangePattern");
        props.add("filter");
        props.add("maxDepth");
        props.add("filterFile");
        props.add("pollStrategy");
        props.add("tempFileName");
        props.add("forceWrites");
        props.add("antFilterCaseSensitive");
        props.add("shuffle");
        props.add("excludeExt");
        props.add("chmodDirectory");
        props.add("bufferSize");
        props.add("filterDirectory");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

