/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.consumer;

import java.io.File;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.resume.ResumableSet;

public final class FileResumeSet
implements ResumableSet<File> {
    private final File[] inputFiles;
    private File[] outputFiles;

    public FileResumeSet(File[] inputFiles) {
        this.inputFiles = Objects.requireNonNull(inputFiles, "A list of input files must be provided for the resume info");
    }

    public void resumeEach(Predicate<File> resumableCheck) {
        this.outputFiles = (File[])this.resumeEach(this.inputFiles, resumableCheck);
    }

    public File[] resumed() {
        return this.outputFiles;
    }

    public boolean hasResumables() {
        return this.outputFiles != this.inputFiles;
    }
}

