/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.cluster;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.camel.component.file.cluster.FileLockClusterLeaderInfo;

final class FileLockClusterUtils {
    static final int UUID_BYTE_LENGTH = 36;
    static final int LOCKFILE_BUFFER_SIZE = 52;

    private FileLockClusterUtils() {
    }

    static void writeClusterLeaderInfo(Path leaderDataPath, FileChannel channel, FileLockClusterLeaderInfo clusterLeaderInfo, boolean forceMetaData) throws IOException {
        Objects.requireNonNull(channel, "channel cannot be null");
        Objects.requireNonNull(clusterLeaderInfo, "clusterLeaderInfo cannot be null");
        if (!Files.exists(leaderDataPath, new LinkOption[0])) {
            throw new FileNotFoundException("Cluster leader data file " + String.valueOf(leaderDataPath) + " not found");
        }
        String uuidStr = clusterLeaderInfo.getId();
        byte[] uuidBytes = uuidStr.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buf = ByteBuffer.allocate(52);
        buf.put(uuidBytes);
        buf.putLong(clusterLeaderInfo.getHeartbeatUpdateIntervalNanoseconds());
        buf.putLong(clusterLeaderInfo.getHeartbeatNanoseconds());
        buf.flip();
        if (forceMetaData) {
            channel.truncate(0L);
        }
        channel.position(0L);
        while (buf.hasRemaining()) {
            channel.write(buf);
        }
        channel.force(forceMetaData);
    }

    static FileLockClusterLeaderInfo readClusterLeaderInfo(Path leaderDataPath) throws IOException {
        if (!Files.exists(leaderDataPath, new LinkOption[0])) {
            return null;
        }
        byte[] bytes = Files.readAllBytes(leaderDataPath);
        if (bytes.length < 52) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        byte[] uuidBytes = new byte[36];
        buf.get(uuidBytes);
        String uuidStr = new String(uuidBytes, StandardCharsets.UTF_8);
        long intervalNanos = buf.getLong();
        long lastHeartbeat = buf.getLong();
        return new FileLockClusterLeaderInfo(uuidStr, intervalNanos, lastHeartbeat);
    }

    static boolean isLeaderStale(FileLockClusterLeaderInfo latestClusterLeaderInfo, FileLockClusterLeaderInfo previousClusterLeaderInfo, long currentNanoTime, int heartbeatTimeoutMultiplier) {
        long previousObservedHeartbeat;
        if (latestClusterLeaderInfo == null) {
            return true;
        }
        if (!latestClusterLeaderInfo.equals(previousClusterLeaderInfo)) {
            return false;
        }
        long latestHeartbeat = latestClusterLeaderInfo.getHeartbeatNanoseconds();
        if (latestHeartbeat > (previousObservedHeartbeat = previousClusterLeaderInfo.getHeartbeatNanoseconds())) {
            return false;
        }
        if (latestHeartbeat < previousObservedHeartbeat) {
            return true;
        }
        long elapsed = currentNanoTime - previousObservedHeartbeat;
        long heartbeatUpdateIntervalNanoseconds = latestClusterLeaderInfo.getHeartbeatUpdateIntervalNanoseconds();
        long timeout = heartbeatUpdateIntervalNanoseconds * (long)heartbeatTimeoutMultiplier;
        return elapsed > timeout;
    }
}

