/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flink.springboot;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.flink.FlinkComponent;
import org.apache.camel.component.flink.springboot.FlinkComponentConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={FlinkComponentConfiguration.class})
public class FlinkComponentAutoConfiguration {
    @Bean(name={"flink-component"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={FlinkComponent.class})
    public FlinkComponent configureFlinkComponent(CamelContext camelContext, FlinkComponentConfiguration configuration) throws Exception {
        FlinkComponent component = new FlinkComponent();
        component.setCamelContext(camelContext);
        HashMap parameters = new HashMap();
        IntrospectionSupport.getProperties((Object)configuration, parameters, null, (boolean)false);
        for (Map.Entry entry : parameters.entrySet()) {
            Object value = entry.getValue();
            Class<?> paramClass = value.getClass();
            if (!paramClass.getName().endsWith("NestedConfiguration")) continue;
            Class nestedClass = null;
            try {
                nestedClass = (Class)paramClass.getDeclaredField("CAMEL_NESTED_CLASS").get(null);
                HashMap nestedParameters = new HashMap();
                IntrospectionSupport.getProperties(value, nestedParameters, null, (boolean)false);
                Object nestedProperty = nestedClass.newInstance();
                IntrospectionSupport.setProperties((CamelContext)camelContext, (TypeConverter)camelContext.getTypeConverter(), nestedProperty, nestedParameters);
                entry.setValue(nestedProperty);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        IntrospectionSupport.setProperties((CamelContext)camelContext, (TypeConverter)camelContext.getTypeConverter(), (Object)component, parameters);
        return component;
    }
}

