/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fop;

import java.io.InputStream;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.fop.FopComponent;
import org.apache.camel.component.fop.FopProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ResourceHelper;
import org.apache.fop.apps.FopFactory;

@UriEndpoint(scheme="fop", syntax="fop:outputFormat", producerOnly=true, label="transformation")
public class FopEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required="true")
    private String outputFormat;
    @UriParam
    private String userConfigURL;
    @UriParam
    private FopFactory fopFactory;

    public FopEndpoint(String uri, FopComponent component, String outputFormat) {
        super(uri, (Component)component);
        this.outputFormat = outputFormat;
    }

    public Producer createProducer() throws Exception {
        return new FopProducer(this, this.fopFactory, this.outputFormat);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for FOP endpoint");
    }

    public boolean isSingleton() {
        return true;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getUserConfigURL() {
        return this.userConfigURL;
    }

    public void setUserConfigURL(String userConfigURL) {
        this.userConfigURL = userConfigURL;
    }

    public FopFactory getFopFactory() {
        return this.fopFactory;
    }

    public void setFopFactory(FopFactory fopFactory) {
        this.fopFactory = fopFactory;
    }

    private static void updateConfigurations(InputStream is, FopFactory fopFactory) throws Exception {
        DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
        Configuration cfg = cfgBuilder.build(is);
        fopFactory.setUserConfig(cfg);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.fopFactory == null) {
            this.fopFactory = FopFactory.newInstance();
        }
        if (this.userConfigURL != null) {
            InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.getCamelContext().getClassResolver(), (String)this.userConfigURL);
            FopEndpoint.updateConfigurations(is, this.fopFactory);
        }
    }
}

