/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fop;

import java.io.InputStream;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.fop.FopComponent;
import org.apache.camel.component.fop.FopOutputType;
import org.apache.camel.component.fop.FopProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ResourceHelper;
import org.apache.fop.apps.FopFactory;

@UriEndpoint(scheme="fop", title="FOP", syntax="fop:outputType", producerOnly=true, label="transformation")
public class FopEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required="true")
    private FopOutputType outputType;
    @UriParam
    private String userConfigURL;
    @UriParam
    private FopFactory fopFactory;

    public FopEndpoint(String uri, FopComponent component, FopOutputType outputType) {
        super(uri, (Component)component);
        this.outputType = outputType;
    }

    public Producer createProducer() throws Exception {
        return new FopProducer(this, this.fopFactory, this.outputType.getFormatExtended());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for FOP endpoint");
    }

    public boolean isSingleton() {
        return true;
    }

    public FopOutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(FopOutputType outputType) {
        this.outputType = outputType;
    }

    public String getUserConfigURL() {
        return this.userConfigURL;
    }

    public void setUserConfigURL(String userConfigURL) {
        this.userConfigURL = userConfigURL;
    }

    public FopFactory getFopFactory() {
        return this.fopFactory;
    }

    public void setFopFactory(FopFactory fopFactory) {
        this.fopFactory = fopFactory;
    }

    private static void updateConfigurations(InputStream is, FopFactory fopFactory) throws Exception {
        DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
        Configuration cfg = cfgBuilder.build(is);
        fopFactory.setUserConfig(cfg);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.fopFactory == null) {
            this.fopFactory = FopFactory.newInstance();
        }
        if (this.userConfigURL != null) {
            InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.userConfigURL);
            FopEndpoint.updateConfigurations(is, this.fopFactory);
        }
    }
}

