/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fop;

public enum FopOutputType {
    pdf("application/pdf"),
    ps("application/postscript"),
    pcl("application/x-pcl"),
    png("image/png"),
    jpeg("image/jpeg"),
    svg("image/svg+xml"),
    xml("application/X-fop-areatree"),
    mif("application/mif"),
    rtf("application/rtf"),
    txt("text/plain");

    private final String outputFormatExtended;

    private FopOutputType(String outputFormatExtended) {
        this.outputFormatExtended = outputFormatExtended;
    }

    public String getFormatExtended() {
        return this.outputFormatExtended;
    }

    public static FopOutputType asFooOutputType(String outputFormatExtended) {
        if ("application/pdf".equalsIgnoreCase(outputFormatExtended)) {
            return pdf;
        }
        if ("application/postscript".equalsIgnoreCase(outputFormatExtended)) {
            return ps;
        }
        if ("application/x-pcl".equalsIgnoreCase(outputFormatExtended)) {
            return pcl;
        }
        if ("image/png".equalsIgnoreCase(outputFormatExtended)) {
            return png;
        }
        if ("image/jpeg".equalsIgnoreCase(outputFormatExtended)) {
            return jpeg;
        }
        if ("image/svg+xml".equalsIgnoreCase(outputFormatExtended)) {
            return svg;
        }
        if ("application/X-fop-areatree".equalsIgnoreCase(outputFormatExtended)) {
            return xml;
        }
        if ("application/mif".equalsIgnoreCase(outputFormatExtended)) {
            return mif;
        }
        if ("application/rtf".equalsIgnoreCase(outputFormatExtended)) {
            return rtf;
        }
        if ("text/plain".equalsIgnoreCase(outputFormatExtended)) {
            return txt;
        }
        return null;
    }
}

