/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Proxy;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.RemoteFileProducer;
import org.apache.camel.component.file.remote.SftpComponent;
import org.apache.camel.component.file.remote.SftpConfiguration;
import org.apache.camel.component.file.remote.SftpConsumer;
import org.apache.camel.component.file.remote.SftpOperations;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(scheme="sftp", extendsScheme="file", title="SFTP", syntax="sftp:host:port/directoryName", consumerClass=SftpConsumer.class, label="file")
public class SftpEndpoint
extends RemoteFileEndpoint<ChannelSftp.LsEntry> {
    @UriParam
    protected SftpConfiguration configuration;
    @UriParam(label="advanced")
    protected Proxy proxy;

    public SftpEndpoint() {
    }

    public SftpEndpoint(String uri, SftpComponent component, SftpConfiguration configuration) {
        super(uri, component, configuration);
        this.configuration = configuration;
    }

    @Override
    public SftpConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GenericFileConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("SftpConfiguration expected");
        }
        this.configuration = (SftpConfiguration)configuration;
        super.setConfiguration(configuration);
    }

    @Override
    protected RemoteFileConsumer<ChannelSftp.LsEntry> buildConsumer(Processor processor) {
        return new SftpConsumer(this, processor, this.createRemoteFileOperations());
    }

    @Override
    protected GenericFileProducer<ChannelSftp.LsEntry> buildProducer() {
        return new RemoteFileProducer<ChannelSftp.LsEntry>(this, this.createRemoteFileOperations());
    }

    @Override
    public RemoteFileOperations<ChannelSftp.LsEntry> createRemoteFileOperations() {
        SftpOperations operations = new SftpOperations(this.proxy);
        operations.setEndpoint(this);
        return operations;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public String getScheme() {
        return "sftp";
    }
}

