/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.file.FileProcessStrategy;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.remote.FtpConfiguration;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.FtpUtils;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.strategy.FtpProcessStrategyFactory;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.commons.net.ftp.FTPFile;

@org.apache.camel.spi.annotations.Component(value="ftp")
@FileProcessStrategy(value=FtpProcessStrategyFactory.class)
public class FtpComponent
extends RemoteFileComponent<FTPFile> {
    public FtpComponent() {
    }

    public FtpComponent(CamelContext context) {
        super(context);
    }

    protected GenericFileEndpoint<FTPFile> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String baseUri = this.getBaseUri(uri);
        FtpConfiguration config = new FtpConfiguration(new URI(baseUri));
        FtpUtils.ensureRelativeFtpDirectory((Component)this, config);
        FtpEndpoint<FTPFile> answer = new FtpEndpoint<FTPFile>(uri, (RemoteFileComponent<FTPFile>)this, config);
        this.extractAndSetFtpClientConfigParameters(parameters, answer);
        this.extractAndSetFtpClientParameters(parameters, answer);
        return answer;
    }

    protected String getBaseUri(String uri) {
        String baseUri = uri;
        if (uri.indexOf("?") != -1) {
            baseUri = uri.substring(0, uri.indexOf("?"));
        }
        return baseUri;
    }

    protected void extractAndSetFtpClientConfigParameters(Map<String, Object> parameters, FtpEndpoint<FTPFile> answer) {
        if (IntrospectionSupport.hasProperties(parameters, (String)"ftpClientConfig.")) {
            Map param = IntrospectionSupport.extractProperties(parameters, (String)"ftpClientConfig.");
            answer.setFtpClientConfigParameters(param);
        }
    }

    protected void extractAndSetFtpClientParameters(Map<String, Object> parameters, FtpEndpoint<FTPFile> answer) {
        if (IntrospectionSupport.hasProperties(parameters, (String)"ftpClient.")) {
            Map param = IntrospectionSupport.extractProperties(parameters, (String)"ftpClient.");
            answer.setFtpClientParameters(param);
        }
    }

    protected void afterPropertiesSet(GenericFileEndpoint<FTPFile> endpoint) throws Exception {
    }
}

