/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.Proxy;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.RemoteFileProducer;
import org.apache.camel.component.file.remote.SftpComponent;
import org.apache.camel.component.file.remote.SftpConfiguration;
import org.apache.camel.component.file.remote.SftpConsumer;
import org.apache.camel.component.file.remote.SftpDefaultMoveExistingFileStrategy;
import org.apache.camel.component.file.remote.SftpOperations;
import org.apache.camel.component.file.remote.SftpRemoteFile;
import org.apache.camel.component.file.remote.strategy.SftpProcessStrategyFactory;
import org.apache.camel.component.file.strategy.FileMoveExistingStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(firstVersion="1.1.0", scheme="sftp", extendsScheme="file", title="SFTP", syntax="sftp:host:port/directoryName", label="file")
@Metadata(excludeProperties="appendChars,bufferSize,siteCommand,directoryMustExist,extendedAttributes,probeContentType,startingDirectoryMustExist,startingDirectoryMustHaveAccess,forceWrites,copyAndDeleteOnRenameFail,renameUsingCopy")
public class SftpEndpoint
extends RemoteFileEndpoint<SftpRemoteFile> {
    @UriParam
    protected SftpConfiguration configuration;
    @UriParam(label="advanced")
    protected Proxy proxy;

    public SftpEndpoint() {
    }

    public SftpEndpoint(String uri, SftpComponent component, SftpConfiguration configuration) {
        super(uri, component, configuration);
        this.configuration = configuration;
    }

    @Override
    public SftpConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GenericFileConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("SftpConfiguration expected");
        }
        this.configuration = (SftpConfiguration)configuration;
        super.setConfiguration(configuration);
    }

    @Override
    protected RemoteFileConsumer<SftpRemoteFile> buildConsumer(Processor processor) {
        return new SftpConsumer(this, processor, this.createRemoteFileOperations(), this.processStrategy != null ? this.processStrategy : this.createGenericFileStrategy());
    }

    @Override
    protected GenericFileProducer<SftpRemoteFile> buildProducer() {
        if (this.getMoveExistingFileStrategy() == null) {
            this.setMoveExistingFileStrategy(this.createDefaultSftpMoveExistingFileStrategy());
        }
        return new RemoteFileProducer<SftpRemoteFile>(this, this.createRemoteFileOperations());
    }

    private FileMoveExistingStrategy createDefaultSftpMoveExistingFileStrategy() {
        return new SftpDefaultMoveExistingFileStrategy();
    }

    protected GenericFileProcessStrategy<SftpRemoteFile> createGenericFileStrategy() {
        return new SftpProcessStrategyFactory().createGenericFileProcessStrategy(this.getCamelContext(), this.getParamsAsMap());
    }

    @Override
    public RemoteFileOperations<SftpRemoteFile> createRemoteFileOperations() {
        SftpOperations operations = new SftpOperations(this.proxy);
        operations.setEndpoint(this);
        return operations;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public String getScheme() {
        return "sftp";
    }
}

