/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.file.FileProcessStrategy;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.remote.FtpComponent;
import org.apache.camel.component.file.remote.FtpUtils;
import org.apache.camel.component.file.remote.FtpsConfiguration;
import org.apache.camel.component.file.remote.FtpsEndpoint;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.strategy.FtpProcessStrategyFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.PropertiesHelper;
import org.apache.commons.net.ftp.FTPFile;

@org.apache.camel.spi.annotations.Component(value="ftps")
@FileProcessStrategy(value=FtpProcessStrategyFactory.class)
public class FtpsComponent
extends FtpComponent
implements SSLContextParametersAware {
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public FtpsComponent() {
    }

    public FtpsComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected GenericFileEndpoint<FTPFile> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String baseUri = this.getBaseUri(uri);
        FtpsConfiguration config = new FtpsConfiguration(new URI(baseUri));
        FtpUtils.ensureRelativeFtpDirectory((Component)this, config);
        FtpsEndpoint endpoint = new FtpsEndpoint(uri, (RemoteFileComponent<FTPFile>)this, config);
        this.extractAndSetFtpClientKeyStoreParameters(parameters, endpoint);
        this.extractAndSetFtpClientTrustStoreParameters(parameters, endpoint);
        this.extractAndSetFtpClientConfigParameters(parameters, endpoint);
        this.extractAndSetFtpClientParameters(parameters, endpoint);
        if (endpoint.getSslContextParameters() == null) {
            endpoint.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return endpoint;
    }

    protected void extractAndSetFtpClientKeyStoreParameters(Map<String, Object> parameters, FtpsEndpoint endpoint) {
        if (PropertiesHelper.hasProperties(parameters, (String)"ftpClient.keyStore.")) {
            Map param = PropertiesHelper.extractProperties(parameters, (String)"ftpClient.keyStore.");
            endpoint.setFtpClientKeyStoreParameters(param);
        }
    }

    protected void extractAndSetFtpClientTrustStoreParameters(Map<String, Object> parameters, FtpsEndpoint endpoint) {
        if (PropertiesHelper.hasProperties(parameters, (String)"ftpClient.trustStore.")) {
            Map param = PropertiesHelper.extractProperties(parameters, (String)"ftpClient.trustStore.");
            endpoint.setFtpClientTrustStoreParameters(param);
        }
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

