/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.remote.FtpEndpointConfigurer;
import org.apache.camel.component.file.remote.FtpsEndpoint;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.strategy.FileMoveExistingStrategy;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;

public class FtpsEndpointConfigurer
extends FtpEndpointConfigurer
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        FtpsEndpoint target = (FtpsEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "disablesecuredatachanneldefaults": 
            case "disableSecureDataChannelDefaults": {
                target.getConfiguration().setDisableSecureDataChannelDefaults((Boolean)FtpsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "execpbsz": 
            case "execPbsz": {
                target.getConfiguration().setExecPbsz((Long)FtpsEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "execprot": 
            case "execProt": {
                target.getConfiguration().setExecProt((String)FtpsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ftpclientkeystoreparameters": 
            case "ftpClientKeyStoreParameters": {
                target.setFtpClientKeyStoreParameters((Map)FtpsEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "ftpclienttruststoreparameters": 
            case "ftpClientTrustStoreParameters": {
                target.setFtpClientTrustStoreParameters((Map)FtpsEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "implicit": {
                target.getConfiguration().setImplicit((Boolean)FtpsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "securityprotocol": 
            case "securityProtocol": {
                target.getConfiguration().setSecurityProtocol((String)FtpsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                target.setSslContextParameters((SSLContextParameters)FtpsEndpointConfigurer.property((CamelContext)camelContext, SSLContextParameters.class, (Object)value));
                return true;
            }
        }
        return super.configure(camelContext, obj, name, value, ignoreCase);
    }

    @Override
    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        FtpsEndpoint target = (FtpsEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "disablesecuredatachanneldefaults": 
            case "disableSecureDataChannelDefaults": {
                return target.getConfiguration().isDisableSecureDataChannelDefaults();
            }
            case "execpbsz": 
            case "execPbsz": {
                return target.getConfiguration().getExecPbsz();
            }
            case "execprot": 
            case "execProt": {
                return target.getConfiguration().getExecProt();
            }
            case "ftpclientkeystoreparameters": 
            case "ftpClientKeyStoreParameters": {
                return target.getFtpClientKeyStoreParameters();
            }
            case "ftpclienttruststoreparameters": 
            case "ftpClientTrustStoreParameters": {
                return target.getFtpClientTrustStoreParameters();
            }
            case "implicit": {
                return target.getConfiguration().isImplicit();
            }
            case "securityprotocol": 
            case "securityProtocol": {
                return target.getConfiguration().getSecurityProtocol();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return target.getSslContextParameters();
            }
        }
        return super.getOptionValue(obj, name, ignoreCase);
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("host", String.class);
        map.put("port", Integer.TYPE);
        map.put("directoryName", String.class);
        map.put("binary", Boolean.TYPE);
        map.put("charset", String.class);
        map.put("disconnect", Boolean.TYPE);
        map.put("doneFileName", String.class);
        map.put("fileName", String.class);
        map.put("passiveMode", Boolean.TYPE);
        map.put("separator", RemoteFileConfiguration.PathSeparator.class);
        map.put("transferLoggingIntervalSeconds", Integer.TYPE);
        map.put("transferLoggingLevel", LoggingLevel.class);
        map.put("transferLoggingVerbose", Boolean.TYPE);
        map.put("fastExistsCheck", Boolean.TYPE);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("delete", Boolean.TYPE);
        map.put("moveFailed", String.class);
        map.put("noop", Boolean.TYPE);
        map.put("preMove", String.class);
        map.put("preSort", Boolean.TYPE);
        map.put("recursive", Boolean.TYPE);
        map.put("resumeDownload", Boolean.TYPE);
        map.put("sendEmptyMessageWhenIdle", Boolean.TYPE);
        map.put("streamDownload", Boolean.TYPE);
        map.put("download", Boolean.TYPE);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("handleDirectoryParserAbsoluteResult", Boolean.TYPE);
        map.put("ignoreFileNotFoundOrPermissionError", Boolean.TYPE);
        map.put("inProgressRepository", IdempotentRepository.class);
        map.put("localWorkDirectory", String.class);
        map.put("onCompletionExceptionHandler", ExceptionHandler.class);
        map.put("pollStrategy", PollingConsumerPollStrategy.class);
        map.put("processStrategy", GenericFileProcessStrategy.class);
        map.put("useList", Boolean.TYPE);
        map.put("fileExist", GenericFileExist.class);
        map.put("flatten", Boolean.TYPE);
        map.put("jailStartingDirectory", Boolean.TYPE);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("moveExisting", String.class);
        map.put("tempFileName", String.class);
        map.put("tempPrefix", String.class);
        map.put("allowNullBody", Boolean.TYPE);
        map.put("chmod", String.class);
        map.put("disconnectOnBatchComplete", Boolean.TYPE);
        map.put("eagerDeleteTargetFile", Boolean.TYPE);
        map.put("keepLastModified", Boolean.TYPE);
        map.put("moveExistingFileStrategy", FileMoveExistingStrategy.class);
        map.put("sendNoop", Boolean.TYPE);
        map.put("activePortRange", String.class);
        map.put("autoCreate", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("bufferSize", Integer.TYPE);
        map.put("connectTimeout", Integer.TYPE);
        map.put("ftpClient", FTPClient.class);
        map.put("ftpClientConfig", FTPClientConfig.class);
        map.put("ftpClientConfigParameters", Map.class);
        map.put("ftpClientParameters", Map.class);
        map.put("maximumReconnectAttempts", Integer.TYPE);
        map.put("reconnectDelay", Long.TYPE);
        map.put("siteCommand", String.class);
        map.put("soTimeout", Integer.TYPE);
        map.put("stepwise", Boolean.TYPE);
        map.put("synchronous", Boolean.TYPE);
        map.put("throwExceptionOnConnectFailed", Boolean.TYPE);
        map.put("timeout", Integer.TYPE);
        map.put("antExclude", String.class);
        map.put("antFilterCaseSensitive", Boolean.TYPE);
        map.put("antInclude", String.class);
        map.put("eagerMaxMessagesPerPoll", Boolean.TYPE);
        map.put("exclude", String.class);
        map.put("filter", GenericFileFilter.class);
        map.put("filterDirectory", String.class);
        map.put("filterFile", String.class);
        map.put("idempotent", Boolean.class);
        map.put("idempotentKey", String.class);
        map.put("idempotentRepository", IdempotentRepository.class);
        map.put("include", String.class);
        map.put("maxDepth", Integer.TYPE);
        map.put("maxMessagesPerPoll", Integer.TYPE);
        map.put("minDepth", Integer.TYPE);
        map.put("move", String.class);
        map.put("exclusiveReadLockStrategy", GenericFileExclusiveReadLockStrategy.class);
        map.put("readLock", String.class);
        map.put("readLockCheckInterval", Long.TYPE);
        map.put("readLockDeleteOrphanLockFiles", Boolean.TYPE);
        map.put("readLockLoggingLevel", LoggingLevel.class);
        map.put("readLockMarkerFile", Boolean.TYPE);
        map.put("readLockMinAge", Long.TYPE);
        map.put("readLockMinLength", Long.TYPE);
        map.put("readLockRemoveOnCommit", Boolean.TYPE);
        map.put("readLockRemoveOnRollback", Boolean.TYPE);
        map.put("readLockTimeout", Long.TYPE);
        map.put("backoffErrorThreshold", Integer.TYPE);
        map.put("backoffIdleThreshold", Integer.TYPE);
        map.put("backoffMultiplier", Integer.TYPE);
        map.put("delay", Long.TYPE);
        map.put("greedy", Boolean.TYPE);
        map.put("initialDelay", Long.TYPE);
        map.put("repeatCount", Long.TYPE);
        map.put("runLoggingLevel", LoggingLevel.class);
        map.put("scheduledExecutorService", ScheduledExecutorService.class);
        map.put("scheduler", Object.class);
        map.put("schedulerProperties", Map.class);
        map.put("startScheduler", Boolean.TYPE);
        map.put("timeUnit", TimeUnit.class);
        map.put("useFixedDelay", Boolean.TYPE);
        map.put("account", String.class);
        map.put("disableSecureDataChannelDefaults", Boolean.TYPE);
        map.put("execPbsz", Long.class);
        map.put("execProt", String.class);
        map.put("ftpClientKeyStoreParameters", Map.class);
        map.put("ftpClientTrustStoreParameters", Map.class);
        map.put("implicit", Boolean.TYPE);
        map.put("password", String.class);
        map.put("securityProtocol", String.class);
        map.put("sslContextParameters", SSLContextParameters.class);
        map.put("username", String.class);
        map.put("shuffle", Boolean.TYPE);
        map.put("sortBy", String.class);
        map.put("sorter", Comparator.class);
        ALL_OPTIONS = map;
    }
}

