/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.RemoteFilePollingConsumerPollStrategy;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteFileConsumer<T>
extends GenericFileConsumer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteFileConsumer.class);
    protected transient boolean loggedIn;
    protected transient boolean loggedInWarning;

    public RemoteFileConsumer(RemoteFileEndpoint<T> endpoint, Processor processor, RemoteFileOperations<T> operations, GenericFileProcessStrategy processStrategy) {
        super(endpoint, processor, operations, processStrategy);
        this.setPollStrategy((PollingConsumerPollStrategy)new RemoteFilePollingConsumerPollStrategy());
    }

    public RemoteFileEndpoint<T> getEndpoint() {
        return (RemoteFileEndpoint)super.getEndpoint();
    }

    protected RemoteFileOperations<T> getOperations() {
        return (RemoteFileOperations)this.operations;
    }

    protected Exchange createExchange(GenericFile<T> file) {
        Exchange answer = this.createExchange(true);
        if (file != null) {
            file.bindToExchange(answer);
        }
        return answer;
    }

    protected boolean prePollCheck() throws Exception {
        block5: {
            if (LOG.isTraceEnabled()) {
                LOG.trace("prePollCheck on {}", (Object)this.getEndpoint().getConfiguration().remoteServerInformation());
            }
            try {
                this.connectIfNecessary();
            }
            catch (Exception e) {
                this.loggedIn = false;
                if (!this.getEndpoint().getConfiguration().isThrowExceptionOnConnectFailed()) break block5;
                throw e;
            }
        }
        if (!this.loggedIn) {
            String message = "Cannot connect/login to: " + this.remoteServer() + ". Will skip this poll.";
            if (!this.loggedInWarning) {
                LOG.warn(message);
                this.loggedInWarning = true;
            }
            return false;
        }
        this.loggedInWarning = false;
        return true;
    }

    protected void postPollCheck(int polledMessages) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("postPollCheck on {}", (Object)this.getEndpoint().getConfiguration().remoteServerInformation());
        }
        if (polledMessages == 0 && this.getEndpoint().isDisconnect()) {
            LOG.trace("postPollCheck disconnect from: {}", this.getEndpoint());
            this.disconnect();
        }
    }

    protected boolean processExchange(Exchange exchange) {
        boolean isLast = (Boolean)exchange.getProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)true, Boolean.class);
        if (isLast && this.getEndpoint().isDisconnect()) {
            exchange.getExchangeExtension().addOnCompletion((Synchronization)new SynchronizationAdapter(){

                public void onDone(Exchange exchange) {
                    LOG.trace("processExchange disconnect from: {}", RemoteFileConsumer.this.getEndpoint());
                    RemoteFileConsumer.this.disconnect();
                }

                public boolean allowHandover() {
                    return false;
                }

                public int getOrder() {
                    return 2147482647;
                }

                public String toString() {
                    return "Disconnect";
                }
            });
        }
        return super.processExchange(exchange);
    }

    protected boolean isRetrieveFile() {
        return this.getEndpoint().isDownload();
    }

    protected boolean hasStartingDirectory() {
        String dir = this.endpoint.getConfiguration().getDirectory();
        if (ObjectHelper.isEmpty((String)dir)) {
            return false;
        }
        return !dir.equals("/") && !dir.equals("\\");
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.disconnect();
    }

    protected void disconnect() {
        block4: {
            this.loggedIn = false;
            try {
                if (this.getOperations().isConnected()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Disconnecting from: {}", (Object)this.remoteServer());
                    }
                    this.getOperations().disconnect();
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("Error occurred while disconnecting from {} due: {} This exception will be ignored.", new Object[]{this.remoteServer(), e.getMessage(), e});
            }
        }
    }

    protected void forceDisconnect() {
        block3: {
            this.loggedIn = false;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Force disconnecting from: {}", (Object)this.remoteServer());
                }
                this.getOperations().forceDisconnect();
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Error occurred while disconnecting from {} due: {} This exception will be ignored.", new Object[]{this.remoteServer(), e.getMessage(), e});
            }
        }
    }

    protected void connectIfNecessary() {
        boolean isConnected;
        block5: {
            isConnected = false;
            try {
                isConnected = this.getOperations().sendNoop();
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("Exception checking connection status: {}", (Object)ex.getMessage());
            }
        }
        if (!this.loggedIn || !isConnected) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not connected/logged in, connecting to: {}", (Object)this.remoteServer());
            }
            this.loggedIn = this.getOperations().connect((RemoteFileConfiguration)this.endpoint.getConfiguration(), null);
            if (this.loggedIn && LOG.isDebugEnabled()) {
                LOG.debug("Connected and logged in to: {}", (Object)this.remoteServer());
            }
        }
    }

    protected String remoteServer() {
        return ((RemoteFileEndpoint)this.endpoint).remoteServerInformation();
    }

    protected boolean doSafePollSubDirectory(String absolutePath, String dirName, List<GenericFile<T>> fileList, int depth) {
        try {
            LOG.trace("Polling sub directory: {} from: {}", (Object)absolutePath, (Object)this.endpoint);
            return this.doPollDirectory(absolutePath, dirName, fileList, depth);
        }
        catch (Exception e) {
            LOG.debug("Caught exception {}", (Object)e.getMessage());
            if (this.ignoreCannotRetrieveFile(absolutePath, null, e)) {
                LOG.trace("Ignoring file error {} for {}", (Object)e.getMessage(), (Object)absolutePath);
                return true;
            }
            LOG.trace("Not ignoring file error {} for {}", (Object)e.getMessage(), (Object)absolutePath);
            if (e instanceof GenericFileOperationFailedException) {
                throw (GenericFileOperationFailedException)((Object)e);
            }
            throw new GenericFileOperationFailedException("Cannot poll sub-directory: " + absolutePath + " from: " + this.endpoint, (Throwable)e);
        }
    }

    protected abstract boolean doPollDirectory(String var1, String var2, List<GenericFile<T>> var3, int var4);
}

