/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote.strategy;

import com.jcraft.jsch.ChannelSftp;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.remote.SftpRemoteFile;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpChangedExclusiveReadLockStrategy
implements GenericFileExclusiveReadLockStrategy<ChannelSftp.LsEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(SftpChangedExclusiveReadLockStrategy.class);
    private long timeout;
    private long checkInterval = 5000L;
    private LoggingLevel readLockLoggingLevel = LoggingLevel.WARN;
    private long minLength = 1L;
    private long minAge;
    private boolean fastExistsCheck;

    public void prepareOnStartup(GenericFileOperations<ChannelSftp.LsEntry> tGenericFileOperations, GenericFileEndpoint<ChannelSftp.LsEntry> tGenericFileEndpoint) throws Exception {
    }

    public boolean acquireExclusiveReadLock(GenericFileOperations<ChannelSftp.LsEntry> operations, GenericFile<ChannelSftp.LsEntry> file, Exchange exchange) throws Exception {
        boolean exclusive = false;
        LOG.trace("Waiting for exclusive read lock to file: {}", file);
        long lastModified = Long.MIN_VALUE;
        long length = Long.MIN_VALUE;
        StopWatch watch = new StopWatch();
        long startTime = System.currentTimeMillis();
        while (!exclusive) {
            Object[] files;
            long delta;
            if (this.timeout > 0L && (delta = watch.taken()) > this.timeout) {
                CamelLogger.log((Logger)LOG, (LoggingLevel)this.readLockLoggingLevel, (String)("Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + String.valueOf(file)));
                return false;
            }
            long newLastModified = 0L;
            long newLength = 0L;
            if (this.fastExistsCheck) {
                String string = file.getAbsoluteFilePath();
                if (string.equals("/") || string.equals("\\")) {
                    LOG.trace("Using fast exists to update file information in home directory");
                    files = operations.listFiles();
                } else {
                    LOG.trace("Using fast exists to update file information for {}", (Object)string);
                    files = operations.listFiles(string);
                }
            } else {
                String string = file.getParent();
                if (string.equals("/") || string.equals("\\")) {
                    LOG.trace("Using full directory listing in home directory to update file information. Consider enabling fastExistsCheck option.");
                    files = operations.listFiles();
                } else {
                    LOG.trace("Using full directory listing to update file information for {}. Consider enabling fastExistsCheck option.", (Object)string);
                    files = operations.listFiles(string);
                }
            }
            LOG.trace("List files {} found {} files", (Object)file.getAbsoluteFilePath(), (Object)files.length);
            for (Object f : files) {
                SftpRemoteFile rf = (SftpRemoteFile)f;
                boolean match = this.fastExistsCheck ? rf.getFilename().equals(file.getAbsoluteFilePath()) || rf.getFilename().equals(file.getFileNameOnly()) : rf.getFilename().equals(file.getFileNameOnly());
                if (!match) continue;
                newLastModified = rf.getLastModified();
                newLength = rf.getFileLength();
            }
            LOG.trace("Previous last modified: {}, new last modified: {}", (Object)lastModified, (Object)newLastModified);
            LOG.trace("Previous length: {}, new length: {}", (Object)length, (Object)newLength);
            long l = startTime + watch.taken() - this.minAge;
            LOG.trace("New older than threshold: {}", (Object)l);
            if (newLength >= this.minLength && (this.minAge == 0L && newLastModified == lastModified && newLength == length || this.minAge != 0L && newLastModified < l)) {
                LOG.trace("Read lock acquired.");
                exclusive = true;
                continue;
            }
            lastModified = newLastModified;
            length = newLength;
            boolean interrupted = this.sleep();
            if (!interrupted) continue;
            return false;
        }
        return exclusive;
    }

    private boolean sleep() {
        LOG.trace("Exclusive read lock not granted. Sleeping for {} millis.", (Object)this.checkInterval);
        try {
            Thread.sleep(this.checkInterval);
            return false;
        }
        catch (InterruptedException e) {
            LOG.debug("Sleep interrupted while waiting for exclusive read lock, so breaking out");
            return true;
        }
    }

    public void releaseExclusiveReadLockOnAbort(GenericFileOperations<ChannelSftp.LsEntry> operations, GenericFile<ChannelSftp.LsEntry> file, Exchange exchange) throws Exception {
    }

    public void releaseExclusiveReadLockOnRollback(GenericFileOperations<ChannelSftp.LsEntry> operations, GenericFile<ChannelSftp.LsEntry> file, Exchange exchange) throws Exception {
    }

    public void releaseExclusiveReadLockOnCommit(GenericFileOperations<ChannelSftp.LsEntry> operations, GenericFile<ChannelSftp.LsEntry> file, Exchange exchange) throws Exception {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        this.readLockLoggingLevel = readLockLoggingLevel;
    }

    public long getMinLength() {
        return this.minLength;
    }

    public void setMinLength(long minLength) {
        this.minLength = minLength;
    }

    public long getMinAge() {
        return this.minAge;
    }

    public void setMinAge(long minAge) {
        this.minAge = minAge;
    }

    public boolean isFastExistsCheck() {
        return this.fastExistsCheck;
    }

    public void setFastExistsCheck(boolean fastExistsCheck) {
        this.fastExistsCheck = fastExistsCheck;
    }

    public void setMarkerFiler(boolean markerFiler) {
    }

    public void setDeleteOrphanLockFiles(boolean deleteOrphanLockFiles) {
    }
}

