/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.geocoder.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.component.geocoder.GeoCoderComponent;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@ConditionalOnBean(type={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@Conditional(value={Condition.class})
@AutoConfigureAfter(name={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
public class GeoCoderComponentAutoConfiguration {
    @Lazy
    @Bean(name={"geocoder-component"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={GeoCoderComponent.class})
    public GeoCoderComponent configureGeoCoderComponent(CamelContext camelContext) throws Exception {
        GeoCoderComponent component = new GeoCoderComponent();
        component.setCamelContext(camelContext);
        return component;
    }

    public static class Condition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            boolean groupEnabled = this.isEnabled(conditionContext, "camel.component.", true);
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"camel.component.geocoder", (Object[])new Object[0]);
            if (this.isEnabled(conditionContext, "camel.component.geocoder.", groupEnabled)) {
                return ConditionOutcome.match((ConditionMessage)message.because("enabled"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
        }

        private boolean isEnabled(ConditionContext context, String prefix, boolean defaultValue) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), prefix);
            return (Boolean)resolver.getProperty("enabled", Boolean.class, (Object)defaultValue);
        }
    }
}

