/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.geocoder.http;

import org.apache.camel.component.geocoder.http.HttpClientConfigurer;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public final class AuthenticationHttpClientConfigurer
implements HttpClientConfigurer {
    private final boolean proxy;
    private final Credentials credentials;

    private AuthenticationHttpClientConfigurer(boolean proxy, Credentials credentials) {
        this.proxy = proxy;
        this.credentials = credentials;
    }

    @Override
    public HttpClient configureHttpClient(HttpClient client) {
        if (this.proxy) {
            client.getState().setProxyCredentials(AuthScope.ANY, this.credentials);
        } else {
            client.getState().setCredentials(AuthScope.ANY, this.credentials);
        }
        return client;
    }

    public static HttpClientConfigurer basicAutenticationConfigurer(boolean proxy, String user, String pwd) {
        return new AuthenticationHttpClientConfigurer(proxy, (Credentials)new UsernamePasswordCredentials(user, pwd));
    }

    public static HttpClientConfigurer ntlmAutenticationConfigurer(boolean proxy, String user, String pwd, String domain, String host) {
        return new AuthenticationHttpClientConfigurer(proxy, (Credentials)new NTCredentials(user, pwd, host, domain));
    }
}

