/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.geocoder;

import com.google.code.geocoder.AdvancedGeoCoder;
import com.google.code.geocoder.Geocoder;
import java.security.InvalidKeyException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.geocoder.GeoCoderComponent;
import org.apache.camel.component.geocoder.GeoCoderProducer;
import org.apache.camel.component.geocoder.http.AuthenticationHttpClientConfigurer;
import org.apache.camel.component.geocoder.http.AuthenticationMethod;
import org.apache.camel.component.geocoder.http.CompositeHttpConfigurer;
import org.apache.camel.component.geocoder.http.HttpClientConfigurer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;

@UriEndpoint(scheme="geocoder", title="Geocoder", syntax="geocoder:address:latlng", producerOnly=true, label="api,location")
public class GeoCoderEndpoint
extends DefaultEndpoint {
    @UriPath
    private String address;
    @UriPath
    private String latlng;
    @UriParam(defaultValue="en")
    private String language = "en";
    @UriParam
    private String clientId;
    @UriParam
    private String clientKey;
    @UriParam
    private boolean headersOnly;
    @UriParam(label="proxy")
    private String proxyHost;
    @UriParam(label="proxy")
    private Integer proxyPort;
    @UriParam(label="proxy")
    private String proxyAuthMethod;
    @UriParam(label="proxy")
    private String proxyAuthUsername;
    @UriParam(label="proxy")
    private String proxyAuthPassword;
    @UriParam(label="proxy")
    private String proxyAuthDomain;
    @UriParam(label="proxy")
    private String proxyAuthHost;
    @UriParam(label="advanced")
    private HttpClientConfigurer httpClientConfigurer;
    @UriParam(label="advanced")
    private HttpConnectionManager httpConnectionManager;

    public GeoCoderEndpoint() {
    }

    public GeoCoderEndpoint(String uri, GeoCoderComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        return new GeoCoderProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from this component");
    }

    public boolean isSingleton() {
        return true;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLatlng() {
        return this.latlng;
    }

    public void setLatlng(String latlng) {
        this.latlng = latlng;
    }

    public boolean isHeadersOnly() {
        return this.headersOnly;
    }

    public void setHeadersOnly(boolean headersOnly) {
        this.headersOnly = headersOnly;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyAuthMethod() {
        return this.proxyAuthMethod;
    }

    public void setProxyAuthMethod(String proxyAuthMethod) {
        this.proxyAuthMethod = proxyAuthMethod;
    }

    public String getProxyAuthUsername() {
        return this.proxyAuthUsername;
    }

    public void setProxyAuthUsername(String proxyAuthUsername) {
        this.proxyAuthUsername = proxyAuthUsername;
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String proxyAuthPassword) {
        this.proxyAuthPassword = proxyAuthPassword;
    }

    public String getProxyAuthDomain() {
        return this.proxyAuthDomain;
    }

    public void setProxyAuthDomain(String proxyAuthDomain) {
        this.proxyAuthDomain = proxyAuthDomain;
    }

    public String getProxyAuthHost() {
        return this.proxyAuthHost;
    }

    public void setProxyAuthHost(String proxyAuthHost) {
        this.proxyAuthHost = proxyAuthHost;
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    Geocoder createGeocoder() throws InvalidKeyException {
        HttpConnectionManager connectionManager = this.httpConnectionManager;
        if (connectionManager == null) {
            connectionManager = new MultiThreadedHttpConnectionManager();
        }
        HttpClient httpClient = new HttpClient(connectionManager);
        if (this.proxyHost != null && this.proxyPort != null) {
            httpClient.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort.intValue());
        }
        if (this.proxyAuthUsername != null && this.proxyAuthMethod == null) {
            throw new IllegalArgumentException("Option proxyAuthMethod must be provided to use proxy authentication");
        }
        CompositeHttpConfigurer configurer = new CompositeHttpConfigurer();
        if (this.proxyAuthMethod != null) {
            this.configureProxyAuth(configurer, this.proxyAuthMethod, this.proxyAuthUsername, this.proxyAuthPassword, this.proxyAuthDomain, this.proxyAuthHost);
        }
        if (this.httpClientConfigurer != null) {
            configurer.addConfigurer(this.httpClientConfigurer);
        }
        configurer.configureHttpClient(httpClient);
        AdvancedGeoCoder geocoder = this.clientId != null ? new AdvancedGeoCoder(httpClient, this.clientId, this.clientKey) : new AdvancedGeoCoder(httpClient);
        return geocoder;
    }

    protected CompositeHttpConfigurer configureProxyAuth(CompositeHttpConfigurer configurer, String authMethod, String username, String password, String domain, String host) {
        if (username == null && authMethod == null) {
            return configurer;
        }
        if (username != null && authMethod == null) {
            throw new IllegalArgumentException("Option proxyAuthMethod must be provided to use proxy authentication");
        }
        ObjectHelper.notNull((Object)authMethod, (String)"proxyAuthMethod");
        ObjectHelper.notNull((Object)username, (String)"proxyAuthUsername");
        ObjectHelper.notNull((Object)password, (String)"proxyAuthPassword");
        AuthenticationMethod auth = (AuthenticationMethod)((Object)this.getCamelContext().getTypeConverter().convertTo(AuthenticationMethod.class, (Object)authMethod));
        if (auth == AuthenticationMethod.Basic || auth == AuthenticationMethod.Digest) {
            configurer.addConfigurer(AuthenticationHttpClientConfigurer.basicAutenticationConfigurer(true, username, password));
            return configurer;
        }
        if (auth == AuthenticationMethod.NTLM) {
            ObjectHelper.notNull((Object)domain, (String)"proxyAuthDomain");
            configurer.addConfigurer(AuthenticationHttpClientConfigurer.ntlmAutenticationConfigurer(true, username, password, domain, host));
            return configurer;
        }
        throw new IllegalArgumentException("Unknown proxyAuthMethod " + authMethod);
    }
}

