/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.geocoder;

import com.google.code.geocoder.Geocoder;
import com.google.code.geocoder.model.GeocodeResponse;
import com.google.code.geocoder.model.GeocoderAddressComponent;
import com.google.code.geocoder.model.GeocoderRequest;
import com.google.code.geocoder.model.GeocoderResult;
import com.google.code.geocoder.model.GeocoderStatus;
import com.google.code.geocoder.model.LatLng;
import java.math.BigDecimal;
import java.net.URL;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.geocoder.GeoCoderEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoCoderProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GeoCoderProducer.class);
    private GeoCoderEndpoint endpoint;
    private Geocoder geocoder;

    public GeoCoderProducer(GeoCoderEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        String latlng;
        String address = (String)exchange.getIn().getHeader("CamelGeoCoderAddress", String.class);
        if (address == null) {
            address = this.endpoint.getAddress();
        }
        if ((latlng = (String)exchange.getIn().getHeader("CamelGeoCoderLatlng", String.class)) == null) {
            latlng = this.endpoint.getLatlng();
        }
        if (latlng != null) {
            GeocoderRequest req = new GeocoderRequest();
            req.setLanguage(this.endpoint.getLanguage());
            String lat = ObjectHelper.before((String)latlng, (String)",");
            String lng = ObjectHelper.after((String)latlng, (String)",");
            req.setLocation(new LatLng(lat, lng));
            LOG.debug("Geocode for lat/lng {}", (Object)latlng);
            GeocodeResponse res = this.geocoder.geocode(req);
            LOG.debug("Geocode response {}", (Object)res);
            if (res != null) {
                this.extractGeoResult(res, exchange);
            }
        } else if (address != null) {
            if ("current".equals(address)) {
                this.processCurrentLocation(exchange);
            } else {
                LOG.debug("Geocode for address {}", (Object)address);
                GeocoderRequest req = new GeocoderRequest(address, this.endpoint.getLanguage());
                GeocodeResponse res = this.geocoder.geocode(req);
                LOG.debug("Geocode response {}", (Object)res);
                if (res != null) {
                    this.extractGeoResult(res, exchange);
                }
            }
        }
    }

    protected void processCurrentLocation(Exchange exchange) throws Exception {
        JsonNode city;
        LOG.debug("Geocode for current address");
        String json = (String)exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, (Object)new URL("https://freegeoip.net/json/"));
        if (ObjectHelper.isEmpty((Object)json)) {
            throw new IllegalStateException("Got the unexpected value '" + json + "' for the geolocation");
        }
        LOG.debug("Geocode response {}", (Object)json);
        exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)GeocoderStatus.OK);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = (JsonNode)mapper.readValue(json, JsonNode.class);
        JsonNode latitudeNode = (JsonNode)ObjectHelper.notNull((Object)node.get("latitude"), (String)"latitude");
        JsonNode longitudeNode = (JsonNode)ObjectHelper.notNull((Object)node.get("longitude"), (String)"longitude");
        String resLatlng = latitudeNode.asText() + "," + longitudeNode.asText();
        exchange.getIn().setHeader("CamelGeoCoderLatlng", (Object)resLatlng);
        JsonNode countryCode = node.get("country_code");
        JsonNode countryName = node.get("country_name");
        if (countryCode != null) {
            exchange.getIn().setHeader("CamelGeoCoderCountryShort", (Object)countryCode.asText());
        }
        if (countryName != null) {
            exchange.getIn().setHeader("CamelGeoCoderCountryLong", (Object)countryName.asText());
        }
        JsonNode regionCode = node.get("region_code");
        JsonNode regionName = node.get("region_name");
        if (regionCode != null) {
            exchange.getIn().setHeader("CamelGeoCoderRegionCode", (Object)regionCode.asText());
        }
        if (regionName != null) {
            exchange.getIn().setHeader("CamelGeoCoderRegionName", (Object)regionName.asText());
        }
        if ((city = node.get("city")) != null) {
            exchange.getIn().setHeader("CamelGeoCoderCity", (Object)city.asText());
        }
        if (!this.endpoint.isHeadersOnly()) {
            exchange.getIn().setBody((Object)json);
        }
    }

    protected void extractGeoResult(GeocodeResponse res, Exchange exchange) {
        exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)res.getStatus());
        if (!this.endpoint.isHeadersOnly()) {
            exchange.getIn().setBody((Object)res);
        }
        if (res.getStatus() == GeocoderStatus.OK) {
            GeocoderAddressComponent city;
            exchange.getIn().setHeader("CamelGeoCoderAddress", (Object)((GeocoderResult)res.getResults().get(0)).getFormattedAddress());
            BigDecimal resLat = ((GeocoderResult)res.getResults().get(0)).getGeometry().getLocation().getLat();
            BigDecimal resLon = ((GeocoderResult)res.getResults().get(0)).getGeometry().getLocation().getLng();
            exchange.getIn().setHeader("CamelGeoCoderLat", (Object)resLat.toPlainString());
            exchange.getIn().setHeader("CamelGeoCoderLng", (Object)resLon.toPlainString());
            String resLatlng = resLat.toPlainString() + "," + resLon.toPlainString();
            exchange.getIn().setHeader("CamelGeoCoderLatlng", (Object)resLatlng);
            GeocoderAddressComponent country = GeoCoderProducer.getCountry(res);
            if (country != null) {
                exchange.getIn().setHeader("CamelGeoCoderCountryShort", (Object)country.getShortName());
                exchange.getIn().setHeader("CamelGeoCoderCountryLong", (Object)country.getLongName());
            }
            if ((city = GeoCoderProducer.getCity(res)) != null) {
                exchange.getIn().setHeader("CamelGeoCoderCity", (Object)city.getLongName());
            }
        }
    }

    private static GeocoderAddressComponent getCountry(GeocodeResponse res) {
        for (GeocoderResult result : res.getResults()) {
            for (String type : result.getTypes()) {
                if (!"country".equals(type)) continue;
                return (GeocoderAddressComponent)result.getAddressComponents().get(0);
            }
        }
        return null;
    }

    private static GeocoderAddressComponent getCity(GeocodeResponse res) {
        for (GeocoderResult result : res.getResults()) {
            for (String type : result.getTypes()) {
                if (!"locality".equals(type)) continue;
                return (GeocoderAddressComponent)result.getAddressComponents().get(0);
            }
        }
        return null;
    }

    protected void doStart() throws Exception {
        this.geocoder = this.endpoint.createGeocoder();
    }
}

