/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery.sql;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.QueryParameter;
import com.google.api.services.bigquery.model.QueryParameterType;
import com.google.api.services.bigquery.model.QueryParameterValue;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLConfiguration;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLEndpoint;
import org.apache.camel.component.google.bigquery.sql.SqlHelper;
import org.apache.camel.impl.DefaultProducer;

public class GoogleBigQuerySQLProducer
extends DefaultProducer {
    private final GoogleBigQuerySQLConfiguration configuration;
    private Bigquery bigquery;
    private String query;
    private Set<String> queryParameterNames;

    public GoogleBigQuerySQLProducer(Bigquery bigquery, GoogleBigQuerySQLEndpoint endpoint, GoogleBigQuerySQLConfiguration configuration) {
        super((Endpoint)endpoint);
        this.bigquery = bigquery;
        this.configuration = configuration;
    }

    public void process(Exchange exchange) throws Exception {
        String translatedQuery = SqlHelper.translateQuery(this.query, exchange);
        Map<String, Object> queryParameters = this.extractParameters(exchange);
        exchange.getMessage().setHeader("CamelGoogleBigQueryTranslatedQuery", (Object)translatedQuery);
        Long affectedRows = this.executeSQL(translatedQuery, queryParameters);
        this.log.debug("The query {} affected {} rows", (Object)this.query, (Object)affectedRows);
        exchange.getMessage().setBody((Object)affectedRows);
    }

    private Long executeSQL(String translatedQuery, Map<String, Object> queryParameters) throws Exception {
        QueryResponse apiResponse;
        QueryRequest apiQueryRequest = new QueryRequest().setQuery(translatedQuery).setUseLegacySql(Boolean.valueOf(false));
        Bigquery.Jobs.Query apiQuery = this.bigquery.jobs().query(this.configuration.getProjectId(), apiQueryRequest);
        this.setQueryParameters(queryParameters, apiQueryRequest);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Sending query to bigquery standard sql: {}", (Object)translatedQuery);
        }
        if ((apiResponse = (QueryResponse)apiQuery.execute()).getErrors() != null && !apiResponse.getErrors().isEmpty()) {
            throw new Exception("Query " + translatedQuery + " failed: " + apiResponse.getErrors());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Result of query {} is {}", (Object)translatedQuery, (Object)apiResponse.toPrettyString());
        }
        return apiResponse.getNumDmlAffectedRows();
    }

    private Map<String, Object> extractParameters(Exchange exchange) {
        if (this.queryParameterNames == null || this.queryParameterNames.size() == 0) {
            return null;
        }
        Message message = exchange.getMessage();
        HashMap headers = new HashMap(message.getHeaders());
        if (message.getBody() instanceof Map) {
            try {
                headers.putAll((Map)message.getBody(Map.class));
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(this.queryParameterNames.size());
        this.queryParameterNames.forEach(s -> {
            Object value = headers.get(s);
            if (value == null) {
                throw new RuntimeExchangeException("SQL parameter with name '" + s + "' not found in the message headers", exchange);
            }
            result.put((String)s, headers.get(s));
        });
        return result;
    }

    private void setQueryParameters(Map<String, Object> params, QueryRequest apiQueryRequest) {
        if (params == null) {
            return;
        }
        ArrayList list = new ArrayList();
        params.forEach((key, value) -> {
            QueryParameter param = new QueryParameter();
            param.setName(key).setParameterType(new QueryParameterType().setType("STRING")).setParameterValue(new QueryParameterValue().setValue(value.toString()));
            list.add(param);
        });
        apiQueryRequest.setQueryParameters(list);
    }

    public boolean isSingleton() {
        return true;
    }

    public GoogleBigQuerySQLEndpoint getEndpoint() {
        return (GoogleBigQuerySQLEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        String placeholder = ":#";
        this.query = SqlHelper.resolveQuery(this.getEndpoint().getCamelContext(), this.configuration.getQuery(), placeholder);
        this.queryParameterNames = SqlHelper.extractParameterNames(this.query);
    }
}

