/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery.sql;

import com.google.cloud.bigquery.BigQuery;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLComponent;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLConfiguration;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.23.0", scheme="google-bigquery-sql", title="Google BigQuery Standard SQL", syntax="google-bigquery-sql:projectId:queryString", label="cloud,messaging", producerOnly=true)
public class GoogleBigQuerySQLEndpoint
extends DefaultEndpoint {
    @UriParam
    protected final GoogleBigQuerySQLConfiguration configuration;

    protected GoogleBigQuerySQLEndpoint(String endpointUri, GoogleBigQuerySQLComponent component, GoogleBigQuerySQLConfiguration configuration) {
        super(endpointUri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        BigQuery bigquery = this.getConfiguration().getConnectionFactory().getDefaultClient();
        GoogleBigQuerySQLProducer producer = new GoogleBigQuerySQLProducer(bigquery, this, this.configuration);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from the BigQuery endpoint: " + this.getEndpointUri());
    }

    public GoogleBigQuerySQLConfiguration getConfiguration() {
        return this.configuration;
    }

    public GoogleBigQuerySQLComponent getComponent() {
        return (GoogleBigQuerySQLComponent)super.getComponent();
    }
}

