/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery;

import org.apache.camel.component.google.bigquery.GoogleBigQueryConnectionFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class GoogleBigQueryConfiguration {
    @UriParam(description="ConnectionFactory to obtain connection to Bigquery Service. If not provided the default one will be used")
    @Metadata(autowired=true)
    private GoogleBigQueryConnectionFactory connectionFactory;
    @UriParam(description="Field name to use as insert id")
    private String useAsInsertId;
    @UriPath(label="common", description="Google Cloud Project Id")
    @Metadata(required=true)
    private String projectId;
    @UriPath(label="common", description="BigQuery Dataset Id")
    @Metadata(required=true)
    private String datasetId;
    @UriPath(label="common", description="BigQuery table id")
    @Metadata(required=false)
    private String tableId;

    public void parseRemaining(String remaining) {
        String[] parts = remaining.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Google BigQuery Endpoint format \"projectId:datasetId[:tableName]\"");
        }
        int c = 0;
        this.projectId = parts[c++];
        this.datasetId = parts[c++];
        if (parts.length > 2) {
            this.tableId = parts[c++];
        }
    }

    public GoogleBigQueryConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(GoogleBigQueryConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getUseAsInsertId() {
        return this.useAsInsertId;
    }

    public GoogleBigQueryConfiguration setUseAsInsertId(String useAsInsertId) {
        this.useAsInsertId = useAsInsertId;
        return this;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public GoogleBigQueryConfiguration setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public GoogleBigQueryConfiguration setDatasetId(String datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    public String getTableId() {
        return this.tableId;
    }

    public GoogleBigQueryConfiguration setTableId(String tableId) {
        this.tableId = tableId;
        return this;
    }
}

