/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery.sql;

import com.google.cloud.bigquery.BigQuery;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.bigquery.GoogleBigQueryConnectionFactory;
import org.apache.camel.component.google.bigquery.GoogleBigQueryConstants;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLComponent;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLConfiguration;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.23.0", scheme="google-bigquery-sql", title="Google BigQuery Standard SQL", syntax="google-bigquery-sql:projectId:queryString", label="cloud,messaging", producerOnly=true, headersClass=GoogleBigQueryConstants.class)
public class GoogleBigQuerySQLEndpoint
extends DefaultEndpoint {
    @UriParam
    protected final GoogleBigQuerySQLConfiguration configuration;
    private BigQuery bigQuery;

    protected GoogleBigQuerySQLEndpoint(String endpointUri, GoogleBigQuerySQLComponent component, GoogleBigQuerySQLConfiguration configuration) {
        super(endpointUri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() {
        return new GoogleBigQuerySQLProducer(this.bigQuery, this, this.configuration);
    }

    protected void doStart() throws Exception {
        super.doStart();
        GoogleBigQueryConnectionFactory connFactory = this.configuration.getConnectionFactory();
        if (connFactory == null) {
            connFactory = new GoogleBigQueryConnectionFactory().setCamelContext(this.getCamelContext()).setServiceAccountKeyFile(this.configuration.getServiceAccountKey());
            this.configuration.setConnectionFactory(connFactory);
        }
        this.bigQuery = connFactory.getDefaultClient();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from the BigQuery endpoint: " + this.getEndpointUri());
    }

    public GoogleBigQuerySQLConfiguration getConfiguration() {
        return this.configuration;
    }

    public GoogleBigQuerySQLComponent getComponent() {
        return (GoogleBigQuerySQLComponent)super.getComponent();
    }
}

