/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.bigquery.GoogleBigQueryConnectionFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class GoogleBigQueryConfiguration
implements Cloneable {
    @UriParam(description="ConnectionFactory to obtain connection to Bigquery Service. If not provided the default one will be used")
    @Metadata(autowired=true)
    private GoogleBigQueryConnectionFactory connectionFactory;
    @UriParam(description="Field name to use as insert id")
    private String useAsInsertId;
    @UriPath(label="common", description="Google Cloud Project Id")
    @Metadata(required=true)
    private String projectId;
    @UriPath(label="common", description="BigQuery Dataset Id")
    @Metadata(required=true)
    private String datasetId;
    @UriPath(label="common", description="BigQuery table id")
    @Metadata(required=false)
    private String tableId;
    @UriParam(label="security", description="Service account key in json format to authenticate an application as a service account to google cloud platform")
    @Metadata(required=false)
    private String serviceAccountKey;

    public void parseRemaining(String remaining) {
        String[] parts = remaining.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Google BigQuery Endpoint format \"projectId:datasetId[:tableName]\"");
        }
        this.projectId = parts[0];
        this.datasetId = parts[1];
        if (parts.length > 2) {
            this.tableId = parts[2];
        }
    }

    public GoogleBigQueryConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(GoogleBigQueryConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getUseAsInsertId() {
        return this.useAsInsertId;
    }

    public GoogleBigQueryConfiguration setUseAsInsertId(String useAsInsertId) {
        this.useAsInsertId = useAsInsertId;
        return this;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public GoogleBigQueryConfiguration setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public GoogleBigQueryConfiguration setDatasetId(String datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    public String getTableId() {
        return this.tableId;
    }

    public GoogleBigQueryConfiguration setTableId(String tableId) {
        this.tableId = tableId;
        return this;
    }

    public String getServiceAccountKey() {
        return this.serviceAccountKey;
    }

    public GoogleBigQueryConfiguration setServiceAccountKey(String serviceAccountKey) {
        this.serviceAccountKey = serviceAccountKey;
        return this;
    }

    public GoogleBigQueryConfiguration copy() {
        try {
            return (GoogleBigQueryConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

