/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery;

import com.google.api.client.util.Strings;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.component.google.bigquery.GoogleBigQueryConfiguration;
import org.apache.camel.component.google.bigquery.GoogleBigQueryEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleBigQueryProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleBigQueryProducer.class);
    private final GoogleBigQueryConfiguration configuration;
    private BigQuery bigquery;

    public GoogleBigQueryProducer(BigQuery bigquery, GoogleBigQueryEndpoint endpoint, GoogleBigQueryConfiguration configuration) {
        super((Endpoint)endpoint);
        this.bigquery = bigquery;
        this.configuration = configuration;
    }

    private static List<Exchange> prepareExchangeList(Exchange exchange) {
        ArrayList<Exchange> entryList;
        if (null == exchange.getProperty(ExchangePropertyKey.GROUPED_EXCHANGE)) {
            entryList = new ArrayList<Exchange>();
            entryList.add(exchange);
        } else {
            entryList = (List)exchange.getProperty(ExchangePropertyKey.GROUPED_EXCHANGE);
        }
        return entryList;
    }

    public void process(Exchange exchange) throws Exception {
        List<Exchange> exchanges = GoogleBigQueryProducer.prepareExchangeList(exchange);
        ArrayList<Exchange> processGroup = new ArrayList<Exchange>();
        String partitionDecorator = "";
        String suffix = "";
        String tableId = this.configuration.getTableId() == null ? "" : this.configuration.getTableId();
        int totalProcessed = 0;
        for (Exchange ex : exchanges) {
            String tmpPartitionDecorator = (String)ex.getIn().getHeader("CamelGoogleBigQueryPartitionDecorator", (Object)"", String.class);
            String tmpSuffix = (String)ex.getIn().getHeader("CamelGoogleBigQueryTableSuffix", (Object)"", String.class);
            String tmpTableId = (String)ex.getIn().getHeader("CamelGoogleBigQueryTableId", (Object)tableId, String.class);
            if (tmpTableId.isEmpty()) {
                throw new IllegalArgumentException("tableId need to be specified in one of endpoint configuration or exchange header");
            }
            if (!(tmpPartitionDecorator.equals(partitionDecorator) && tmpSuffix.equals(suffix) && tmpTableId.equals(tableId))) {
                if (!processGroup.isEmpty()) {
                    totalProcessed += this.process(tableId, partitionDecorator, suffix, processGroup, exchange.getExchangeId());
                }
                processGroup.clear();
                partitionDecorator = tmpPartitionDecorator;
                suffix = tmpSuffix;
                tableId = tmpTableId;
            }
            processGroup.add(ex);
        }
        if (!processGroup.isEmpty()) {
            totalProcessed += this.process(tableId, partitionDecorator, suffix, processGroup, exchange.getExchangeId());
        }
        if (totalProcessed == 0) {
            LOG.debug("The incoming message is either null or empty for exchange {}", (Object)exchange.getExchangeId());
        }
    }

    private int process(String tableId, String partitionDecorator, String suffix, List<Exchange> exchanges, String exchangeId) throws Exception {
        InsertAllResponse apiResponse;
        String tableIdWithPartition = Strings.isNullOrEmpty((String)partitionDecorator) ? tableId : tableId + "$" + partitionDecorator;
        ArrayList<InsertAllRequest.RowToInsert> apiRequestRows = new ArrayList<InsertAllRequest.RowToInsert>();
        for (Exchange ex : exchanges) {
            Object entryObject = ex.getIn().getBody();
            if (entryObject instanceof List) {
                for (Map entry : (List)entryObject) {
                    apiRequestRows.add(this.createRowRequest(null, entry));
                }
                continue;
            }
            if (entryObject instanceof Map) {
                apiRequestRows.add(this.createRowRequest(ex, (Map)entryObject));
                continue;
            }
            ex.setException((Throwable)new IllegalArgumentException("Cannot handle body type " + entryObject.getClass()));
        }
        if (apiRequestRows.isEmpty()) {
            return 0;
        }
        InsertAllRequest.Builder builder = InsertAllRequest.newBuilder((String)this.configuration.getDatasetId(), (String)tableIdWithPartition).setRows(apiRequestRows);
        if (ObjectHelper.isNotEmpty((String)suffix)) {
            builder.setTemplateSuffix(suffix);
        }
        InsertAllRequest insertAllRequest = builder.build();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sending {} messages to bigquery table {}, suffix {}, partition {}", new Object[]{apiRequestRows.size(), tableId, suffix, partitionDecorator});
        }
        if ((apiResponse = this.bigquery.insertAll(insertAllRequest)).getInsertErrors() != null && !apiResponse.getInsertErrors().isEmpty()) {
            throw new Exception("InsertAll into " + tableId + " failed: " + apiResponse.getInsertErrors());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sent {} messages to bigquery table {}, suffix {}, partition {}", new Object[]{apiRequestRows.size(), tableId, suffix, partitionDecorator});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("uploader thread/id: {} / {} . api call completed.", (Object)Thread.currentThread().getId(), (Object)exchangeId);
        }
        return insertAllRequest.getRows().size();
    }

    private InsertAllRequest.RowToInsert createRowRequest(Exchange exchange, Map<String, Object> object) {
        String insertId = null;
        if (this.configuration.getUseAsInsertId() != null) {
            insertId = (String)object.get(this.configuration.getUseAsInsertId());
        } else if (exchange != null) {
            insertId = (String)exchange.getIn().getHeader("CamelGoogleBigQueryInsertId", String.class);
        }
        if (insertId != null) {
            return InsertAllRequest.RowToInsert.of((String)insertId, object);
        }
        return InsertAllRequest.RowToInsert.of(object);
    }

    public GoogleBigQueryEndpoint getEndpoint() {
        return (GoogleBigQueryEndpoint)super.getEndpoint();
    }
}

