/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery;

import com.google.api.client.util.Strings;
import com.google.api.services.bigquery.BigqueryScopes;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleBigQueryConnectionFactory {
    private final Logger logger = LoggerFactory.getLogger(GoogleBigQueryConnectionFactory.class);
    private String serviceAccountKeyFile;
    private String serviceURL;
    private BigQuery client;
    private CamelContext camelContext;

    public GoogleBigQueryConnectionFactory() {
    }

    public GoogleBigQueryConnectionFactory(BigQuery client) {
        this.client = client;
    }

    public synchronized BigQuery getDefaultClient() throws Exception {
        if (this.client == null) {
            this.client = this.buildClient();
        }
        return this.client;
    }

    private BigQuery buildClient() throws Exception {
        GoogleCredentials credentials = null;
        if (!Strings.isNullOrEmpty((String)this.serviceAccountKeyFile)) {
            this.logger.debug("Key File Name has been set explicitly. Initialising BigQuery using Key File {}", (Object)StringHelper.limitLength((String)this.serviceAccountKeyFile, (int)70));
            credentials = this.createFromFile();
        }
        if (credentials == null) {
            this.logger.debug("No explicit Service Account or Key File Name have been provided. Initialising BigQuery using defaults");
            credentials = this.createDefault();
        }
        BigQueryOptions.Builder builder = (BigQueryOptions.Builder)BigQueryOptions.newBuilder().setCredentials(credentials);
        if (ObjectHelper.isNotEmpty((String)this.serviceURL)) {
            builder.setHost(this.serviceURL);
        }
        return (BigQuery)builder.build().getService();
    }

    private GoogleCredentials createFromFile() throws Exception {
        if (this.camelContext == null) {
            throw new CamelException("CamelContext is null, but must be set when creating GoogleBigQueryConnectionFactory.");
        }
        try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.camelContext, (String)this.serviceAccountKeyFile);){
            GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)is);
            if (credentials.createScopedRequired()) {
                credentials = credentials.createScoped((Collection)BigqueryScopes.all());
            }
            GoogleCredentials googleCredentials = credentials;
            return googleCredentials;
        }
    }

    private GoogleCredentials createDefault() throws Exception {
        GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
        List<String> scopes = Collections.singletonList("https://www.googleapis.com/auth/bigquery");
        if (credentials.createScopedRequired()) {
            credentials = credentials.createScoped(scopes);
        }
        return credentials;
    }

    public String getServiceAccountKeyFile() {
        return this.serviceAccountKeyFile;
    }

    public GoogleBigQueryConnectionFactory setServiceAccountKeyFile(String serviceAccountKeyFile) {
        this.serviceAccountKeyFile = serviceAccountKeyFile;
        this.resetClient();
        return this;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public GoogleBigQueryConnectionFactory setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
        this.resetClient();
        return this;
    }

    private synchronized void resetClient() {
        this.client = null;
    }

    public GoogleBigQueryConnectionFactory setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        return this;
    }
}

