/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.calendar.stream;

import com.google.api.services.calendar.Calendar;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.calendar.BatchGoogleCalendarClientFactory;
import org.apache.camel.component.google.calendar.GoogleCalendarClientFactory;
import org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamConfiguration;
import org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="google-calendar-stream")
public class GoogleCalendarStreamComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private Calendar client;
    @Metadata(label="advanced")
    private GoogleCalendarClientFactory clientFactory;
    @Metadata
    private GoogleCalendarStreamConfiguration configuration = new GoogleCalendarStreamConfiguration();

    public GoogleCalendarStreamComponent() {
        this(null);
    }

    public GoogleCalendarStreamComponent(CamelContext context) {
        super(context);
    }

    public Calendar getClient(GoogleCalendarStreamConfiguration config) {
        if (this.client == null) {
            if (config.getClientId() != null && config.getClientSecret() != null) {
                this.client = this.getClientFactory().makeClient(config.getClientId(), config.getClientSecret(), config.getScopes(), config.getApplicationName(), config.getRefreshToken(), config.getAccessToken(), config.getEmailAddress(), config.getP12FileName(), config.getUser());
            } else if (config.getServiceAccountKey() != null) {
                this.client = this.getClientFactory().makeClient(this.getCamelContext(), config.getServiceAccountKey(), config.getScopes(), config.getApplicationName(), config.getDelegate());
            } else {
                throw new IllegalArgumentException("(clientId and clientSecret) or keyResource are required to create Gmail client");
            }
        }
        return this.client;
    }

    public GoogleCalendarClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new BatchGoogleCalendarClientFactory();
        }
        return this.clientFactory;
    }

    public GoogleCalendarStreamConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GoogleCalendarStreamConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setClientFactory(GoogleCalendarClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GoogleCalendarStreamConfiguration configuration = this.configuration.copy();
        GoogleCalendarStreamEndpoint endpoint = new GoogleCalendarStreamEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }
}

