/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.calendar;

import com.google.api.services.calendar.Calendar;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.calendar.GoogleCalendarComponent;
import org.apache.camel.component.google.calendar.GoogleCalendarConfiguration;
import org.apache.camel.component.google.calendar.GoogleCalendarConsumer;
import org.apache.camel.component.google.calendar.GoogleCalendarProducer;
import org.apache.camel.component.google.calendar.internal.GoogleCalendarApiCollection;
import org.apache.camel.component.google.calendar.internal.GoogleCalendarApiName;
import org.apache.camel.component.google.calendar.internal.GoogleCalendarPropertiesHelper;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.ApiName;

@UriEndpoint(firstVersion="2.15.0", scheme="google-calendar", title="Google Calendar", syntax="google-calendar:apiName/methodName", apiSyntax="apiName/methodName", consumerPrefix="consumer", category={Category.API, Category.CLOUD})
public class GoogleCalendarEndpoint
extends AbstractApiEndpoint<GoogleCalendarApiName, GoogleCalendarConfiguration> {
    @UriParam
    private GoogleCalendarConfiguration configuration;
    private Object apiProxy;

    public GoogleCalendarEndpoint(String uri, GoogleCalendarComponent component, GoogleCalendarApiName apiName, String methodName, GoogleCalendarConfiguration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, GoogleCalendarApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        return new GoogleCalendarProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        GoogleCalendarConsumer consumer = new GoogleCalendarConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<GoogleCalendarConfiguration> getPropertiesHelper() {
        return GoogleCalendarPropertiesHelper.getHelper(this.getCamelContext());
    }

    protected String getThreadProfileName() {
        return "CamelGoogleCalendar";
    }

    protected void afterConfigureProperties() {
        switch ((GoogleCalendarApiName)this.apiName) {
            case LIST: {
                this.apiProxy = this.getClient().calendarList();
                break;
            }
            case ACL: {
                this.apiProxy = this.getClient().acl();
                break;
            }
            case CALENDARS: {
                this.apiProxy = this.getClient().calendars();
                break;
            }
            case CHANNELS: {
                this.apiProxy = this.getClient().channels();
                break;
            }
            case COLORS: {
                this.apiProxy = this.getClient().colors();
                break;
            }
            case EVENTS: {
                this.apiProxy = this.getClient().events();
                break;
            }
            case FREEBUSY: {
                this.apiProxy = this.getClient().freebusy();
                break;
            }
            case SETTINGS: {
                this.apiProxy = this.getClient().settings();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid API name " + this.apiName);
            }
        }
    }

    public Calendar getClient() {
        return ((GoogleCalendarComponent)this.getComponent()).getClient(this.configuration);
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return this.apiProxy;
    }
}

