/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.calendar.stream;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.util.DateTime;
import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.Events;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamConfiguration;
import org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamEndpoint;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleCalendarStreamConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleCalendarStreamConsumer.class);
    private DateTime lastUpdate;
    private String syncToken;
    private String pageToken;

    public GoogleCalendarStreamConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    protected GoogleCalendarStreamConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected com.google.api.services.calendar.Calendar getClient() {
        return this.getEndpoint().getClient();
    }

    public GoogleCalendarStreamEndpoint getEndpoint() {
        return (GoogleCalendarStreamEndpoint)super.getEndpoint();
    }

    protected int poll() throws Exception {
        Events c;
        Calendar.Events.List request = this.getClient().events().list(this.getConfiguration().getCalendarId());
        if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getQuery())) {
            request.setQ(this.getConfiguration().getQuery());
        }
        if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getMaxResults())) {
            request.setMaxResults(Integer.valueOf(this.getConfiguration().getMaxResults()));
        }
        if (this.getConfiguration().isConsumeFromNow() && this.syncToken == null) {
            Date date = new Date();
            request.setTimeMin(new DateTime(date));
        }
        if (this.getConfiguration().isConsiderLastUpdate() && ObjectHelper.isNotEmpty((Object)this.lastUpdate)) {
            request.setUpdatedMin(this.lastUpdate);
        }
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        ArrayList<Date> dateList = new ArrayList<Date>();
        if (this.getConfiguration().isSyncFlow()) {
            if (this.syncToken == null && this.pageToken == null) {
                LOG.info("Performing full sync.");
            } else if (this.pageToken != null) {
                LOG.info("Requesting next page.");
            } else {
                LOG.info("Performing incremental sync.");
            }
            request.setSyncToken(this.syncToken);
            request.setPageToken(this.pageToken);
            try {
                c = (Events)request.execute();
            }
            catch (GoogleJsonResponseException e) {
                if (e.getStatusCode() == 410) {
                    LOG.info("Invalid sync token, clearing sync and page tokens and re-syncing.");
                    this.syncToken = null;
                    this.pageToken = null;
                    return this.poll();
                }
                throw e;
            }
            if (c.getItems().isEmpty()) {
                LOG.info("No new events to sync.");
            }
            this.pageToken = c.getNextPageToken();
            if (c.getNextSyncToken() != null) {
                this.syncToken = c.getNextSyncToken();
                LOG.info("Sync complete.");
            }
        } else {
            c = (Events)request.setOrderBy("updated").execute();
        }
        if (c != null) {
            List list = c.getItems();
            for (Event event : list) {
                Exchange exchange = this.getEndpoint().createExchange(this.getEndpoint().getExchangePattern(), event);
                answer.add(exchange);
                DateTime updated = event.getUpdated();
                if (updated == null) continue;
                dateList.add(new Date(updated.getValue()));
            }
        }
        this.lastUpdate = this.retrieveLastUpdateDate(dateList);
        return this.processBatch(CastUtils.cast(answer));
    }

    private DateTime retrieveLastUpdateDate(List<Date> dateList) {
        Date finalLastUpdate;
        if (!dateList.isEmpty()) {
            dateList.sort((o1, o2) -> o1.compareTo((Date)o2));
            Date lastUpdateDate = dateList.get(dateList.size() - 1);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(lastUpdateDate);
            calendar.add(13, 1);
            finalLastUpdate = calendar.getTime();
        } else {
            finalLastUpdate = new Date();
        }
        return new DateTime(finalLastUpdate);
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            this.getAsyncProcessor().process(exchange, doneSync -> {});
        }
        return total;
    }
}

