/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.calendar;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.calendar.Calendar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.calendar.GoogleCalendarClientFactory;
import org.apache.camel.support.ResourceHelper;

public class BatchGoogleCalendarClientFactory
implements GoogleCalendarClientFactory {
    private NetHttpTransport transport = new NetHttpTransport();
    private JacksonFactory jsonFactory = new JacksonFactory();

    @Override
    public Calendar makeClient(String clientId, String clientSecret, Collection<String> scopes, String applicationName, String refreshToken, String accessToken, String emailAddress, String p12FileName, String user) {
        boolean serviceAccount;
        boolean bl = serviceAccount = null != emailAddress && !emailAddress.isEmpty() && null != p12FileName && !p12FileName.isEmpty();
        if (!(serviceAccount || clientId != null && clientSecret != null)) {
            throw new IllegalArgumentException("clientId and clientSecret are required to create Google Calendar client.");
        }
        try {
            Credential credential;
            if (serviceAccount) {
                credential = this.authorizeServiceAccount(emailAddress, p12FileName, scopes, user);
            } else {
                credential = this.authorize(clientId, clientSecret);
                if (refreshToken != null && !refreshToken.isEmpty()) {
                    credential.setRefreshToken(refreshToken);
                }
                if (accessToken != null && !accessToken.isEmpty()) {
                    credential.setAccessToken(accessToken);
                }
            }
            return new Calendar.Builder((HttpTransport)this.transport, (JsonFactory)this.jsonFactory, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Could not create Google Calendar client.", (Throwable)e);
        }
    }

    private Credential authorize(String clientId, String clientSecret) {
        return new GoogleCredential.Builder().setJsonFactory((JsonFactory)this.jsonFactory).setTransport((HttpTransport)this.transport).setClientSecrets(clientId, clientSecret).build();
    }

    private Credential authorizeServiceAccount(String emailAddress, String p12FileName, Collection<String> scopes, String user) throws Exception {
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        return new GoogleCredential.Builder().setTransport((HttpTransport)httpTransport).setJsonFactory((JsonFactory)this.jsonFactory).setServiceAccountId(emailAddress).setServiceAccountPrivateKeyFromP12File(new File(p12FileName)).setServiceAccountScopes(scopes).setServiceAccountUser(user).build();
    }

    @Override
    public Calendar makeClient(CamelContext camelContext, String serviceAccountKey, Collection<String> scopes, String applicationName, String delegate) {
        if (serviceAccountKey == null) {
            throw new IllegalArgumentException("serviceAccountKey is required to create Google Calendar client.");
        }
        try {
            Credential credential = this.authorizeServiceAccount(camelContext, serviceAccountKey, delegate, scopes);
            return new Calendar.Builder((HttpTransport)this.transport, (JsonFactory)this.jsonFactory, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Could not create Google Calendar client.", (Throwable)e);
        }
    }

    private Credential authorizeServiceAccount(CamelContext camelContext, String serviceAccountKey, String delegate, Collection<String> scopes) {
        try {
            GoogleCredential cred = GoogleCredential.fromStream((InputStream)ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)serviceAccountKey), (HttpTransport)this.transport, (JsonFactory)this.jsonFactory).createScoped(scopes != null && !scopes.isEmpty() ? scopes : null).createDelegated(delegate);
            cred.refreshToken();
            return cred;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

