/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.functions;

import com.google.api.client.util.Lists;
import com.google.cloud.functions.v1.CallFunctionRequest;
import com.google.cloud.functions.v1.CallFunctionResponse;
import com.google.cloud.functions.v1.CloudFunction;
import com.google.cloud.functions.v1.CloudFunctionName;
import com.google.cloud.functions.v1.CloudFunctionsServiceClient;
import com.google.cloud.functions.v1.CreateFunctionRequest;
import com.google.cloud.functions.v1.DeleteFunctionRequest;
import com.google.cloud.functions.v1.GenerateDownloadUrlRequest;
import com.google.cloud.functions.v1.GenerateDownloadUrlResponse;
import com.google.cloud.functions.v1.GenerateUploadUrlRequest;
import com.google.cloud.functions.v1.GenerateUploadUrlResponse;
import com.google.cloud.functions.v1.HttpsTrigger;
import com.google.cloud.functions.v1.ListFunctionsRequest;
import com.google.cloud.functions.v1.LocationName;
import com.google.cloud.functions.v1.UpdateFunctionRequest;
import com.google.protobuf.Empty;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsConfiguration;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsEndpoint;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsOperations;
import org.apache.camel.support.DefaultProducer;

public class GoogleCloudFunctionsProducer
extends DefaultProducer {
    private GoogleCloudFunctionsEndpoint endpoint;

    public GoogleCloudFunctionsProducer(GoogleCloudFunctionsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listFunctions: {
                this.listFunctions(this.endpoint.getClient(), exchange);
                break;
            }
            case getFunction: {
                this.getFunction(this.endpoint.getClient(), exchange);
                break;
            }
            case callFunction: {
                this.callFunction(this.endpoint.getClient(), exchange);
                break;
            }
            case generateDownloadUrl: {
                this.generateDownloadUrl(this.endpoint.getClient(), exchange);
                break;
            }
            case generateUploadUrl: {
                this.generateUploadUrl(this.endpoint.getClient(), exchange);
                break;
            }
            case createFunction: {
                this.createFunction(this.endpoint.getClient(), exchange);
                break;
            }
            case updateFunction: {
                this.updateFunction(this.endpoint.getClient(), exchange);
                break;
            }
            case deleteFunction: {
                this.deleteFunction(this.endpoint.getClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void listFunctions(CloudFunctionsServiceClient client, Exchange exchange) throws InvalidPayloadException {
        ListFunctionsRequest request;
        ArrayList response = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (ListFunctionsRequest)exchange.getIn().getMandatoryBody(ListFunctionsRequest.class);
            CloudFunctionsServiceClient.ListFunctionsPagedResponse pagedListResponse = client.listFunctions(request);
            response = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        } else {
            request = ListFunctionsRequest.newBuilder().setParent(LocationName.of((String)this.getConfiguration().getProject(), (String)this.getConfiguration().getLocation()).toString()).setPageSize(Integer.MAX_VALUE).build();
            CloudFunctionsServiceClient.ListFunctionsPagedResponse pagedListResponse = client.listFunctions(request);
            response = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        }
        Message message = GoogleCloudFunctionsProducer.getMessageForResponse(exchange);
        message.setBody((Object)response);
    }

    private void getFunction(CloudFunctionsServiceClient client, Exchange exchange) throws InvalidPayloadException {
        CloudFunction response = null;
        if (this.getConfiguration().isPojoRequest()) {
            CloudFunctionName request = (CloudFunctionName)exchange.getIn().getMandatoryBody(CloudFunctionName.class);
            response = client.getFunction(request);
        } else {
            CloudFunctionName cfName = CloudFunctionName.of((String)this.getConfiguration().getProject(), (String)this.getConfiguration().getLocation(), (String)this.getConfiguration().getFunctionName());
            response = client.getFunction(cfName);
        }
        Message message = GoogleCloudFunctionsProducer.getMessageForResponse(exchange);
        message.setBody((Object)response);
    }

    private void callFunction(CloudFunctionsServiceClient client, Exchange exchange) throws InvalidPayloadException {
        CallFunctionResponse response = null;
        if (this.getConfiguration().isPojoRequest()) {
            CallFunctionRequest request = (CallFunctionRequest)exchange.getIn().getMandatoryBody(CallFunctionRequest.class);
            response = client.callFunction(request);
        } else {
            String data = (String)exchange.getIn().getBody(String.class);
            CloudFunctionName cfName = CloudFunctionName.of((String)this.getConfiguration().getProject(), (String)this.getConfiguration().getLocation(), (String)this.getConfiguration().getFunctionName());
            CallFunctionRequest request = CallFunctionRequest.newBuilder().setName(cfName.toString()).setData(data).build();
            response = client.callFunction(request);
        }
        Message message = GoogleCloudFunctionsProducer.getMessageForResponse(exchange);
        message.setHeader("GoogleCloudFunctionsResponseObject", (Object)response);
        message.setBody((Object)response.getResult());
    }

    private void generateDownloadUrl(CloudFunctionsServiceClient client, Exchange exchange) throws InvalidPayloadException {
        GenerateDownloadUrlResponse response = null;
        if (this.getConfiguration().isPojoRequest()) {
            GenerateDownloadUrlRequest request = (GenerateDownloadUrlRequest)exchange.getIn().getMandatoryBody(GenerateDownloadUrlRequest.class);
            response = client.generateDownloadUrl(request);
        } else {
            CloudFunctionName cfName = CloudFunctionName.of((String)this.getConfiguration().getProject(), (String)this.getConfiguration().getLocation(), (String)this.getConfiguration().getFunctionName());
            GenerateDownloadUrlRequest request = GenerateDownloadUrlRequest.newBuilder().setName(cfName.toString()).build();
            response = client.generateDownloadUrl(request);
        }
        Message message = GoogleCloudFunctionsProducer.getMessageForResponse(exchange);
        message.setHeader("GoogleCloudFunctionsResponseObject", (Object)response);
        message.setBody((Object)response.getDownloadUrl());
    }

    private void generateUploadUrl(CloudFunctionsServiceClient client, Exchange exchange) throws InvalidPayloadException {
        GenerateUploadUrlResponse response = null;
        if (this.getConfiguration().isPojoRequest()) {
            GenerateUploadUrlRequest request = (GenerateUploadUrlRequest)exchange.getIn().getMandatoryBody(GenerateUploadUrlRequest.class);
            response = client.generateUploadUrl(request);
        } else {
            LocationName locationName = LocationName.of((String)this.getConfiguration().getProject(), (String)this.getConfiguration().getLocation());
            GenerateUploadUrlRequest request = GenerateUploadUrlRequest.newBuilder().setParent(locationName.toString()).build();
            response = client.generateUploadUrl(request);
        }
        Message message = GoogleCloudFunctionsProducer.getMessageForResponse(exchange);
        message.setHeader("GoogleCloudFunctionsResponseObject", (Object)response);
        message.setBody((Object)response.getUploadUrl());
    }

    private void createFunction(CloudFunctionsServiceClient client, Exchange exchange) throws InvalidPayloadException, InterruptedException, ExecutionException {
        CloudFunction response = null;
        if (this.getConfiguration().isPojoRequest()) {
            CreateFunctionRequest request = (CreateFunctionRequest)exchange.getIn().getMandatoryBody(CreateFunctionRequest.class);
            response = (CloudFunction)client.createFunctionAsync(request).get();
        } else {
            String project = this.getConfiguration().getProject();
            String location = this.getConfiguration().getLocation();
            String functionName = this.getConfiguration().getFunctionName();
            String entryPoint = (String)exchange.getIn().getHeader("GoogleCloudFunctionsEntryPoint", String.class);
            String runtime = (String)exchange.getIn().getHeader("GoogleCloudFunctionsRuntime", String.class);
            String sourceArchiveUrl = (String)exchange.getIn().getHeader("GoogleCloudFunctionsSourceArchiveUrl", String.class);
            CloudFunction function = CloudFunction.newBuilder().setName(CloudFunctionName.of((String)project, (String)location, (String)functionName).toString()).setEntryPoint(entryPoint).setRuntime(runtime).setHttpsTrigger(HttpsTrigger.getDefaultInstance()).setSourceArchiveUrl(sourceArchiveUrl).build();
            CreateFunctionRequest request = CreateFunctionRequest.newBuilder().setLocation(LocationName.of((String)project, (String)location).toString()).setFunction(function).build();
            response = (CloudFunction)client.createFunctionAsync(request).get();
        }
        Message message = GoogleCloudFunctionsProducer.getMessageForResponse(exchange);
        message.setBody((Object)response);
    }

    private void updateFunction(CloudFunctionsServiceClient client, Exchange exchange) throws InvalidPayloadException, InterruptedException, ExecutionException {
        CloudFunction response = null;
        if (!this.getConfiguration().isPojoRequest()) {
            throw new IllegalArgumentException("updateFunction is supported only in pojo mode");
        }
        UpdateFunctionRequest request = (UpdateFunctionRequest)exchange.getIn().getMandatoryBody(UpdateFunctionRequest.class);
        response = (CloudFunction)client.updateFunctionAsync(request).get();
        Message message = GoogleCloudFunctionsProducer.getMessageForResponse(exchange);
        message.setBody((Object)response);
    }

    private void deleteFunction(CloudFunctionsServiceClient client, Exchange exchange) throws InvalidPayloadException, InterruptedException, ExecutionException {
        Empty response = null;
        if (this.getConfiguration().isPojoRequest()) {
            DeleteFunctionRequest request = (DeleteFunctionRequest)exchange.getIn().getMandatoryBody(DeleteFunctionRequest.class);
            response = (Empty)client.deleteFunctionAsync(request).get();
        } else {
            CloudFunctionName cfName = CloudFunctionName.of((String)this.getConfiguration().getProject(), (String)this.getConfiguration().getLocation(), (String)this.getConfiguration().getFunctionName());
            DeleteFunctionRequest request = DeleteFunctionRequest.newBuilder().setName(cfName.toString()).build();
            response = (Empty)client.deleteFunctionAsync(request).get();
        }
        Message message = GoogleCloudFunctionsProducer.getMessageForResponse(exchange);
        message.setBody((Object)response);
    }

    private GoogleCloudFunctionsOperations determineOperation(Exchange exchange) {
        GoogleCloudFunctionsOperations operation = (GoogleCloudFunctionsOperations)((Object)exchange.getIn().getHeader("GoogleCloudFunctionsOperation", GoogleCloudFunctionsOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation() == null ? GoogleCloudFunctionsOperations.callFunction : this.getConfiguration().getOperation();
        }
        return operation;
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    private GoogleCloudFunctionsConfiguration getConfiguration() {
        return this.endpoint.getConfiguration();
    }
}

