/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail.stream;

import com.google.api.services.gmail.Gmail;
import com.google.api.services.gmail.model.ListMessagesResponse;
import com.google.api.services.gmail.model.Message;
import com.google.api.services.gmail.model.ModifyMessageRequest;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Processor;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamConfiguration;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamEndpoint;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleMailStreamConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleMailStreamConsumer.class);
    private String unreadLabelId;
    private List<String> labelsIds;

    public GoogleMailStreamConsumer(Endpoint endpoint, Processor processor, String unreadLabelId, List<String> labelsIds) {
        super(endpoint, processor);
        this.unreadLabelId = unreadLabelId;
        this.labelsIds = labelsIds;
    }

    protected GoogleMailStreamConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected Gmail getClient() {
        return this.getEndpoint().getClient();
    }

    public GoogleMailStreamEndpoint getEndpoint() {
        return (GoogleMailStreamEndpoint)super.getEndpoint();
    }

    protected int poll() throws Exception {
        Gmail.Users.Messages.List request = this.getClient().users().messages().list("me");
        if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getQuery())) {
            request.setQ(this.getConfiguration().getQuery());
        }
        if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getMaxResults())) {
            request.setMaxResults(Long.valueOf(this.getConfiguration().getMaxResults()));
        }
        if (ObjectHelper.isNotEmpty(this.labelsIds)) {
            request.setLabelIds(this.labelsIds);
        }
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        ListMessagesResponse c = (ListMessagesResponse)request.execute();
        if (c.getMessages() != null) {
            for (Message message : c.getMessages()) {
                Message mess = (Message)this.getClient().users().messages().get("me", message.getId()).setFormat("FULL").execute();
                Exchange exchange = this.getEndpoint().createExchange(this.getEndpoint().getExchangePattern(), mess);
                answer.add(exchange);
            }
        }
        return this.processBatch(CastUtils.cast(answer));
    }

    public int processBatch(Queue<Object> exchanges) {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    GoogleMailStreamConsumer.this.processCommit(exchange, GoogleMailStreamConsumer.this.unreadLabelId);
                }

                public void onFailure(Exchange exchange) {
                    GoogleMailStreamConsumer.this.processRollback(exchange, GoogleMailStreamConsumer.this.unreadLabelId);
                }

                public String toString() {
                    return "GoogleMailStreamConsumerOnCompletion";
                }
            });
            this.getAsyncProcessor().process(exchange, doneSync -> LOG.trace("Processing exchange done"));
        }
        return total;
    }

    protected void processCommit(Exchange exchange, String unreadLabelId) {
        try {
            if (this.getConfiguration().isMarkAsRead()) {
                String id = (String)exchange.getIn().getHeader("CamelGoogleMailId", String.class);
                LOG.trace("Marking email {} as read", (Object)id);
                ArrayList<String> remove = new ArrayList<String>();
                remove.add(unreadLabelId);
                ModifyMessageRequest mods = new ModifyMessageRequest().setRemoveLabelIds(remove);
                this.getClient().users().messages().modify("me", (String)exchange.getIn().getHeader("CamelGoogleMailId", String.class), mods).execute();
                LOG.trace("Marked email {} as read", (Object)id);
            }
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error occurred mark as read mail. This exception is ignored.", exchange, (Throwable)e);
        }
    }

    protected void processRollback(Exchange exchange, String unreadLabelId) {
        try {
            LOG.warn("Exchange failed, so rolling back mail {} to un {}", (Object)exchange, (Object)unreadLabelId);
            ArrayList<String> add = new ArrayList<String>();
            add.add(unreadLabelId);
            ModifyMessageRequest mods = new ModifyMessageRequest().setAddLabelIds(add);
            this.getClient().users().messages().modify("me", (String)exchange.getIn().getHeader("CamelGoogleMailId", String.class), mods).execute();
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error occurred mark as read mail. This exception is ignored.", exchange, (Throwable)e);
        }
    }
}

