/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail.stream;

import com.google.api.services.gmail.Gmail;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.component.google.mail.BatchGoogleMailClientFactory;
import org.apache.camel.component.google.mail.GoogleMailClientFactory;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamComponentVerifierExtension;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamConfiguration;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="google-mail-stream")
public class GoogleMailStreamComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private Gmail client;
    @Metadata(label="advanced")
    private GoogleMailClientFactory clientFactory;
    @Metadata(label="advanced")
    private GoogleMailStreamConfiguration configuration;

    public GoogleMailStreamComponent() {
        this(null);
    }

    public GoogleMailStreamComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new GoogleMailStreamComponentVerifierExtension());
        this.configuration = new GoogleMailStreamConfiguration();
    }

    public Gmail getClient(GoogleMailStreamConfiguration googleMailConfiguration) {
        if (this.client == null) {
            this.client = this.getClientFactory().makeClient(googleMailConfiguration.getClientId(), googleMailConfiguration.getClientSecret(), googleMailConfiguration.getApplicationName(), googleMailConfiguration.getRefreshToken(), googleMailConfiguration.getAccessToken());
        }
        return this.client;
    }

    public GoogleMailClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new BatchGoogleMailClientFactory();
        }
        return this.clientFactory;
    }

    public GoogleMailStreamConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GoogleMailStreamConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setClientFactory(GoogleMailClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GoogleMailStreamConfiguration configuration = this.configuration.copy();
        configuration.setIndex(remaining);
        GoogleMailStreamEndpoint endpoint = new GoogleMailStreamEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }
}

