/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail.stream.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="google-mail-stream:application-cloudevents", description="Adds CloudEvent headers to the Camel message with Google Mail Stream consumer response details")
public class GoogleMailStreamCloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.google.mail.stream.consume");
        if (message.getHeaders().containsKey("CamelGoogleMailStreamFrom")) {
            headers.put("CamelCloudEventSource", "google.mail.stream." + (String)message.getHeader("CamelGoogleMailStreamFrom", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelGoogleMailStreamSubject", String.class));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "application/octet-stream");
    }
}

