/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub.consumer;

import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.pubsub.v1.AcknowledgeRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Synchronization;

public class AcknowledgeSync
implements Synchronization {
    private final Callable<SubscriberStub> subscriberStubSupplier;
    private final String subscriptionName;

    public AcknowledgeSync(Callable<SubscriberStub> subscriberStubSupplier, String subscriptionName) {
        this.subscriberStubSupplier = subscriberStubSupplier;
        this.subscriptionName = subscriptionName;
    }

    public void onComplete(Exchange exchange) {
        AcknowledgeRequest ackRequest = AcknowledgeRequest.newBuilder().addAllAckIds(this.getAckIdList(exchange)).setSubscription(this.subscriptionName).build();
        try (SubscriberStub subscriber = this.subscriberStubSupplier.call();){
            subscriber.acknowledgeCallable().call((Object)ackRequest);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void onFailure(Exchange exchange) {
    }

    private List<String> getAckIdList(Exchange exchange) {
        String ackId;
        ArrayList<String> ackList = new ArrayList<String>();
        if (exchange.getIn().getBody() instanceof List) {
            for (Object body : (List)exchange.getIn().getBody(List.class)) {
                String ackId2;
                if (!(body instanceof Exchange) || null == (ackId2 = (String)exchange.getIn().getHeader("CamelGooglePubsub.MsgAckId", String.class))) continue;
                ackList.add(ackId2);
            }
        }
        if (null != (ackId = (String)exchange.getIn().getHeader("CamelGooglePubsub.MsgAckId", String.class))) {
            ackList.add(ackId);
        }
        return ackList;
    }
}

