/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.pubsub.GooglePubsubEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="google-pubsub")
public class GooglePubsubComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(GooglePubsubComponent.class);
    @Metadata(label="common", description="Endpoint to use with local Pub/Sub emulator.")
    private String endpoint;
    @Metadata(label="producer", description="Maximum number of producers to cache. This could be increased if you have producers for lots of different topics.")
    private int publisherCacheSize = 100;
    @Metadata(label="producer", description="How many milliseconds should each producer stay alive in the cache.")
    private int publisherCacheTimeout = 180000;
    @Metadata(label="advanced", description="How many milliseconds should a producer be allowed to terminate.")
    private int publisherTerminationTimeout = 60000;
    private RemovalListener<String, Publisher> removalListener = removal -> {
        Publisher publisher = (Publisher)removal.getValue();
        if (publisher == null) {
            return;
        }
        publisher.shutdown();
        try {
            publisher.awaitTermination((long)this.publisherTerminationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    };
    private Cache<String, Publisher> cachedPublishers = CacheBuilder.newBuilder().expireAfterWrite((long)this.publisherCacheTimeout, TimeUnit.MILLISECONDS).maximumSize((long)this.publisherCacheSize).removalListener(this.removalListener).build();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String[] parts = remaining.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Google PubSub Endpoint format \"projectId:destinationName[:subscriptionName]\"");
        }
        GooglePubsubEndpoint pubsubEndpoint = new GooglePubsubEndpoint(uri, (Component)this, remaining);
        pubsubEndpoint.setProjectId(parts[0]);
        pubsubEndpoint.setDestinationName(parts[1]);
        this.setProperties((Endpoint)pubsubEndpoint, parameters);
        return pubsubEndpoint;
    }

    protected void doShutdown() throws Exception {
        this.cachedPublishers.cleanUp();
        this.cachedPublishers.invalidateAll();
        super.doShutdown();
    }

    public Publisher getPublisher(String topicName, GooglePubsubEndpoint googlePubsubEndpoint) throws ExecutionException {
        return (Publisher)this.cachedPublishers.get((Object)topicName, () -> this.buildPublisher(topicName, googlePubsubEndpoint));
    }

    private Publisher buildPublisher(String topicName, GooglePubsubEndpoint googlePubsubEndpoint) throws IOException {
        Publisher.Builder builder = Publisher.newBuilder((String)topicName);
        if (StringHelper.trimToNull((String)this.endpoint) != null) {
            ManagedChannel channel = ManagedChannelBuilder.forTarget((String)this.endpoint).usePlaintext().build();
            FixedTransportChannelProvider channelProvider = FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)channel));
            NoCredentialsProvider credentialsProvider = NoCredentialsProvider.create();
            builder.setChannelProvider((TransportChannelProvider)channelProvider).setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        if (StringHelper.trimToNull((String)googlePubsubEndpoint.getPubsubEndpoint()) != null) {
            builder.setEndpoint(googlePubsubEndpoint.getPubsubEndpoint());
        }
        if (googlePubsubEndpoint.isMessageOrderingEnabled()) {
            builder.setEnableMessageOrdering(true);
            if (StringHelper.trimToNull((String)googlePubsubEndpoint.getPubsubEndpoint()) == null) {
                LOG.warn("In conjunction with enabeling message ordering the pubsubEndpoint should be set. Message ordering is only guaranteed when send to the same region.");
            }
        }
        return builder.build();
    }

    public Subscriber getSubscriber(String subscriptionName, MessageReceiver messageReceiver) {
        Subscriber.Builder builder = Subscriber.newBuilder((String)subscriptionName, (MessageReceiver)messageReceiver);
        if (StringHelper.trimToNull((String)this.endpoint) != null) {
            ManagedChannel channel = ManagedChannelBuilder.forTarget((String)this.endpoint).usePlaintext().build();
            FixedTransportChannelProvider channelProvider = FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)channel));
            NoCredentialsProvider credentialsProvider = NoCredentialsProvider.create();
            builder.setChannelProvider((TransportChannelProvider)channelProvider).setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        return builder.build();
    }

    public SubscriberStub getSubscriberStub() throws IOException {
        SubscriberStubSettings.Builder builder = (SubscriberStubSettings.Builder)SubscriberStubSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)SubscriberStubSettings.defaultGrpcTransportProviderBuilder().build());
        if (StringHelper.trimToNull((String)this.endpoint) != null) {
            ManagedChannel channel = ManagedChannelBuilder.forTarget((String)this.endpoint).usePlaintext().build();
            FixedTransportChannelProvider channelProvider = FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)channel));
            NoCredentialsProvider credentialsProvider = NoCredentialsProvider.create();
            ((SubscriberStubSettings.Builder)builder.setTransportChannelProvider((TransportChannelProvider)channelProvider)).setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        return builder.build().createStub();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public int getPublisherCacheSize() {
        return this.publisherCacheSize;
    }

    public void setPublisherCacheSize(int publisherCacheSize) {
        this.publisherCacheSize = publisherCacheSize;
    }

    public int getPublisherCacheTimeout() {
        return this.publisherCacheTimeout;
    }

    public void setPublisherCacheTimeout(int publisherCacheTimeout) {
        this.publisherCacheTimeout = publisherCacheTimeout;
    }

    public int getPublisherTerminationTimeout() {
        return this.publisherTerminationTimeout;
    }

    public void setPublisherTerminationTimeout(int publisherTerminationTimeout) {
        this.publisherTerminationTimeout = publisherTerminationTimeout;
    }
}

