/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.secret.manager.vault;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PubsubMessage;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerPropertiesFunction;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.spi.annotations.PeriodicTask;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.vault.GcpVaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PeriodicTask(value="gcp-secret-refresh")
public class PubsubReloadTriggerTask
extends ServiceSupport
implements CamelContextAware,
Runnable {
    private static final String CAMEL_VAULT_GCP_SERVICE_ACCOUNT_KEY = "CAMEL_VAULT_GCP_SERVICE_ACCOUNT_KEY";
    private static final String CAMEL_VAULT_GCP_PROJECT_ID = "CAMEL_VAULT_GCP_PROJECT_ID";
    private static final String CAMEL_VAULT_GCP_USE_DEFAULT_INSTANCE = "CAMEL_VAULT_GCP_USE_DEFAULT_INSTANCE";
    private static final String CAMEL_VAULT_GCP_SUBSCRIPTION_NAME = "CAMEL_VAULT_GCP_SUBSCRIPTION_NAME";
    private static final Logger LOG = LoggerFactory.getLogger(PubsubReloadTriggerTask.class);
    private CamelContext camelContext;
    private boolean reloadEnabled = true;
    private String secrets;
    private Subscriber subscriber;
    private GoogleSecretManagerPropertiesFunction propertiesFunction;
    private volatile Instant lastCheckTime;
    private volatile Instant lastReloadTime;
    private final Map<String, Instant> updates = new HashMap<String, Instant>();

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public void setReloadEnabled(boolean reloadEnabled) {
        this.reloadEnabled = reloadEnabled;
    }

    public Map<String, Instant> getUpdates() {
        return Collections.unmodifiableMap(this.updates);
    }

    public Instant getLastCheckTime() {
        return this.lastCheckTime;
    }

    public Instant getLastReloadTime() {
        return this.lastReloadTime;
    }

    protected void doStart() throws Exception {
        GcpVaultConfiguration gcpVaultConfiguration;
        super.doStart();
        PropertiesComponent pc = this.camelContext.getPropertiesComponent();
        PropertiesFunction pf = pc.getPropertiesFunction("gcp");
        if (pf instanceof GoogleSecretManagerPropertiesFunction) {
            this.propertiesFunction = (GoogleSecretManagerPropertiesFunction)pf;
            LOG.debug("Auto-detecting secrets from properties-function: {}", (Object)pf.getName());
        }
        this.secrets = this.camelContext.getVaultConfiguration().aws().getSecrets();
        if (ObjectHelper.isEmpty((String)this.secrets) && this.propertiesFunction == null) {
            throw new IllegalArgumentException("Secrets must be configured on GCP vault configuration");
        }
        String serviceAccountKey = System.getenv(CAMEL_VAULT_GCP_SERVICE_ACCOUNT_KEY);
        boolean useDefaultInstance = Boolean.parseBoolean(System.getenv(CAMEL_VAULT_GCP_USE_DEFAULT_INSTANCE));
        String projectId = System.getenv(CAMEL_VAULT_GCP_PROJECT_ID);
        String subscription = System.getenv(CAMEL_VAULT_GCP_SUBSCRIPTION_NAME);
        if (ObjectHelper.isEmpty((String)serviceAccountKey) && ObjectHelper.isEmpty((String)projectId) && ObjectHelper.isEmpty((String)subscription) && ObjectHelper.isNotEmpty((Object)(gcpVaultConfiguration = this.getCamelContext().getVaultConfiguration().gcp()))) {
            serviceAccountKey = gcpVaultConfiguration.getServiceAccountKey();
            projectId = gcpVaultConfiguration.getProjectId();
            useDefaultInstance = gcpVaultConfiguration.isUseDefaultInstance();
            subscription = gcpVaultConfiguration.getSubscriptionName();
        }
        if (ObjectHelper.isNotEmpty((String)serviceAccountKey) && ObjectHelper.isNotEmpty((String)projectId) && ObjectHelper.isNotEmpty((String)subscription)) {
            InputStream resolveMandatoryResourceAsInputStream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)serviceAccountKey);
            ServiceAccountCredentials myCredentials = ServiceAccountCredentials.fromStream((InputStream)resolveMandatoryResourceAsInputStream);
            ProjectSubscriptionName subscriptionName = ProjectSubscriptionName.of((String)projectId, (String)subscription);
            Subscriber.Builder builder = Subscriber.newBuilder((ProjectSubscriptionName)subscriptionName, (MessageReceiver)new FilteringEventMessageReceiver());
            builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)myCredentials));
            this.subscriber = builder.build();
        } else if (useDefaultInstance && ObjectHelper.isNotEmpty((String)projectId) && ObjectHelper.isNotEmpty((String)subscription)) {
            ProjectSubscriptionName subscriptionName = ProjectSubscriptionName.of((String)projectId, (String)subscription);
            Subscriber.Builder builder = Subscriber.newBuilder((ProjectSubscriptionName)subscriptionName, (MessageReceiver)new FilteringEventMessageReceiver());
            builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)GoogleCredentials.getApplicationDefault()));
            this.subscriber = builder.build();
        } else {
            throw new RuntimeCamelException("Using the GCP Secret refresh task requires setting GCP service account key, project Id and Google Pubsub subscription name as application properties or environment variables");
        }
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.subscriber != null) {
            try {
                this.subscriber.stopAsync();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.subscriber = null;
        }
        this.updates.clear();
    }

    @Override
    public void run() {
        this.lastCheckTime = Instant.now();
        this.subscriber.startAsync().awaitRunning();
    }

    protected boolean matchSecret(String name) {
        HashSet<String> set = new HashSet<String>();
        if (this.secrets != null) {
            Collections.addAll(set, this.secrets.split(","));
        }
        if (this.propertiesFunction != null) {
            set.addAll(this.propertiesFunction.getSecrets());
        }
        for (String part : set) {
            boolean result = name.contains(part) || PatternHelper.matchPattern((String)name, (String)part);
            LOG.trace("Matching secret id: {}={} -> {}", new Object[]{name, part, result});
            if (!result) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Google Secrets Refresh Task";
    }

    public class FilteringEventMessageReceiver
    implements MessageReceiver {
        private static final String SECRET_UPDATE = "SECRET_UPDATE";
        private static final String SECRET_VERSION_ADD = "SECRET_VERSION_ADD";
        private boolean triggerReloading;

        public void receiveMessage(PubsubMessage message, AckReplyConsumer consumer) {
            ContextReloadStrategy reload;
            String secretId = (String)message.getAttributesMap().get("secretId");
            String eventType = (String)message.getAttributesMap().get("eventType");
            if ((eventType.equalsIgnoreCase(SECRET_UPDATE) || eventType.equalsIgnoreCase(SECRET_VERSION_ADD)) && PubsubReloadTriggerTask.this.matchSecret(secretId)) {
                int secretNameBeginInd = secretId.lastIndexOf("/") + 1;
                PubsubReloadTriggerTask.this.updates.put(secretId.substring(secretNameBeginInd), Instant.ofEpochSecond(message.getPublishTime().getSeconds(), message.getPublishTime().getNanos()));
                if (PubsubReloadTriggerTask.this.isReloadEnabled()) {
                    LOG.info("Update for GCP secret: {} detected, triggering CamelContext reload", (Object)secretId.toString());
                    this.triggerReloading = true;
                }
            }
            if (this.triggerReloading && (reload = (ContextReloadStrategy)PubsubReloadTriggerTask.this.camelContext.hasService(ContextReloadStrategy.class)) != null) {
                PubsubReloadTriggerTask.this.lastReloadTime = Instant.now();
                reload.onReload((Object)this);
            }
            consumer.ack();
        }
    }
}

