/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.secret.manager;

import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerClientFactory;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerComponent;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerConfiguration;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerConstants;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="3.16.0", scheme="google-secret-manager", title="Google Secret Manager", syntax="google-secret-manager:project", category={Category.CLOUD}, producerOnly=true, headersClass=GoogleSecretManagerConstants.class)
@Metadata(annotations={"vault=google-secret-manager"})
public class GoogleSecretManagerEndpoint
extends DefaultEndpoint {
    @UriParam
    private GoogleSecretManagerConfiguration configuration;
    private SecretManagerServiceClient secretManagerServiceClient;

    public GoogleSecretManagerEndpoint(String uri, GoogleSecretManagerComponent component, GoogleSecretManagerConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new GoogleSecretManagerProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from the google-secret-manager endpoint: " + this.getEndpointUri());
    }

    public GoogleSecretManagerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GoogleSecretManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.secretManagerServiceClient = this.configuration.getClient() != null ? this.configuration.getClient() : GoogleSecretManagerClientFactory.create(this.getCamelContext(), this.configuration);
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.configuration.getClient() == null && this.secretManagerServiceClient != null) {
            this.secretManagerServiceClient.close();
        }
    }

    public SecretManagerServiceClient getClient() {
        return this.secretManagerServiceClient;
    }
}

