/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets;

import com.google.api.services.sheets.v4.Sheets;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.component.google.sheets.BatchGoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.GoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.GoogleSheetsConfiguration;
import org.apache.camel.component.google.sheets.GoogleSheetsEndpoint;
import org.apache.camel.component.google.sheets.GoogleSheetsVerifierExtension;
import org.apache.camel.component.google.sheets.internal.GoogleSheetsApiCollection;
import org.apache.camel.component.google.sheets.internal.GoogleSheetsApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.component.AbstractApiComponent;
import org.apache.camel.util.component.ApiCollection;

@Metadata(label="verifiers", enums="parameters,connectivity")
public class GoogleSheetsComponent
extends AbstractApiComponent<GoogleSheetsApiName, GoogleSheetsConfiguration, GoogleSheetsApiCollection> {
    @Metadata(label="advanced")
    private Sheets client;
    @Metadata(label="advanced")
    private GoogleSheetsClientFactory clientFactory;

    public GoogleSheetsComponent() {
        super(GoogleSheetsEndpoint.class, GoogleSheetsApiName.class, (ApiCollection)GoogleSheetsApiCollection.getCollection());
        this.registerExtension((ComponentExtension)new GoogleSheetsVerifierExtension("google-sheets"));
    }

    public GoogleSheetsComponent(CamelContext context) {
        super(context, GoogleSheetsEndpoint.class, GoogleSheetsApiName.class, (ApiCollection)GoogleSheetsApiCollection.getCollection());
        this.registerExtension((ComponentExtension)new GoogleSheetsVerifierExtension("google-sheets", context));
    }

    protected GoogleSheetsApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return GoogleSheetsApiName.fromValue(apiNameStr);
    }

    public Sheets getClient(GoogleSheetsConfiguration config) {
        if (this.client == null) {
            this.client = this.getClientFactory().makeClient(config.getClientId(), config.getClientSecret(), config.getApplicationName(), config.getRefreshToken(), config.getAccessToken());
        }
        return this.client;
    }

    public GoogleSheetsClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new BatchGoogleSheetsClientFactory();
        }
        return this.clientFactory;
    }

    public void setConfiguration(GoogleSheetsConfiguration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public GoogleSheetsConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new GoogleSheetsConfiguration();
        }
        return (GoogleSheetsConfiguration)super.getConfiguration();
    }

    public void setClientFactory(GoogleSheetsClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected Endpoint createEndpoint(String uri, String methodName, GoogleSheetsApiName apiName, GoogleSheetsConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new GoogleSheetsEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }
}

