/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets;

import com.google.api.services.sheets.v4.Sheets;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.component.google.sheets.BatchGoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.GoogleSheetsConfiguration;

public class GoogleSheetsVerifierExtension
extends DefaultComponentVerifierExtension {
    public GoogleSheetsVerifierExtension(String defaultScheme) {
        super(defaultScheme);
    }

    public GoogleSheetsVerifierExtension(String defaultScheme, CamelContext context) {
        super(defaultScheme, context);
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption((String)"applicationName", parameters)).error(ResultErrorHelper.requiresOption((String)"clientId", parameters)).error(ResultErrorHelper.requiresOption((String)"clientSecret", parameters));
        return builder.build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY);
        try {
            GoogleSheetsConfiguration configuration = (GoogleSheetsConfiguration)this.setProperties(new GoogleSheetsConfiguration(), parameters);
            BatchGoogleSheetsClientFactory clientFactory = new BatchGoogleSheetsClientFactory();
            Sheets client = clientFactory.makeClient(configuration.getClientId(), configuration.getClientSecret(), configuration.getApplicationName(), configuration.getRefreshToken(), configuration.getAccessToken());
            client.spreadsheets().get(Optional.ofNullable(parameters.get("spreadsheetId")).map(Object::toString).orElse(UUID.randomUUID().toString())).execute();
        }
        catch (Exception e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)e.getMessage()).detail("google_sheets_exception_message", (Object)e.getMessage()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)e.getClass().getName()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)e);
            builder.error(errorBuilder.build());
        }
        return builder.build();
    }
}

