/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets.stream;

import com.google.api.services.sheets.v4.Sheets;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.sheets.GoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamComponent;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamConfiguration;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamConsumer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;

@UriEndpoint(firstVersion="2.23.0", scheme="google-sheets-stream", title="Google Sheets Stream", syntax="google-sheets-stream:spreadsheetId", consumerOnly=true, category={Category.CLOUD, Category.SHEETS})
public class GoogleSheetsStreamEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private GoogleSheetsStreamConfiguration configuration;

    public GoogleSheetsStreamEndpoint(String uri, GoogleSheetsStreamComponent component, GoogleSheetsStreamConfiguration endpointConfiguration) {
        super(uri, (Component)component);
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("The camel google sheets stream component doesn't support producer");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        GoogleSheetsStreamConsumer consumer = new GoogleSheetsStreamConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Sheets getClient() {
        return ((GoogleSheetsStreamComponent)this.getComponent()).getClient(this.configuration);
    }

    public GoogleSheetsClientFactory getClientFactory() {
        return ((GoogleSheetsStreamComponent)this.getComponent()).getClientFactory();
    }

    public void setClientFactory(GoogleSheetsClientFactory clientFactory) {
        ((GoogleSheetsStreamComponent)this.getComponent()).setClientFactory(clientFactory);
    }

    public GoogleSheetsStreamConfiguration getConfiguration() {
        return this.configuration;
    }
}

