/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.sheets.v4.Sheets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.sheets.GoogleSheetsClientFactory;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;

public class BatchGoogleSheetsClientFactory
implements GoogleSheetsClientFactory {
    private final HttpTransport transport;
    private final JacksonFactory jsonFactory;

    public BatchGoogleSheetsClientFactory() {
        this((HttpTransport)new NetHttpTransport(), new JacksonFactory());
    }

    public BatchGoogleSheetsClientFactory(HttpTransport httpTransport) {
        this(httpTransport, new JacksonFactory());
    }

    public BatchGoogleSheetsClientFactory(HttpTransport httpTransport, JacksonFactory jacksonFactory) {
        this.transport = httpTransport;
        this.jsonFactory = jacksonFactory;
    }

    @Override
    public Sheets makeClient(String clientId, String clientSecret, Collection<String> scopes, String applicationName, String refreshToken, String accessToken) {
        if (clientId == null || clientSecret == null) {
            throw new IllegalArgumentException("clientId and clientSecret are required to create Google Sheets client.");
        }
        try {
            Credential credential = this.authorize(clientId, clientSecret, scopes, refreshToken, accessToken);
            Sheets.Builder clientBuilder = new Sheets.Builder(this.transport, (JsonFactory)this.jsonFactory, (HttpRequestInitializer)credential).setApplicationName(applicationName);
            this.configure(clientBuilder);
            return clientBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Could not create Google Sheets client.", (Throwable)e);
        }
    }

    protected void configure(Sheets.Builder clientBuilder) {
        clientBuilder.setRootUrl("https://sheets.googleapis.com/");
    }

    private Credential authorize(String clientId, String clientSecret, Collection<String> scopes, String refreshToken, String accessToken) {
        GoogleCredential credential = new GoogleCredential.Builder().setJsonFactory((JsonFactory)this.jsonFactory).setTransport(this.transport).setClientSecrets(clientId, clientSecret).setServiceAccountScopes(scopes).build();
        if (ObjectHelper.isNotEmpty((Object)refreshToken)) {
            credential.setRefreshToken(refreshToken);
        }
        if (ObjectHelper.isNotEmpty((Object)accessToken)) {
            credential.setAccessToken(accessToken);
        }
        return credential;
    }

    @Override
    public Sheets makeClient(CamelContext camelContext, String keyResource, Collection<String> scopes, String applicationName, String delegate) {
        if (keyResource == null) {
            throw new IllegalArgumentException("keyResource is required to create Google Sheets client.");
        }
        try {
            Credential credential = this.authorizeServiceAccount(camelContext, keyResource, delegate, scopes);
            return new Sheets.Builder(this.transport, (JsonFactory)this.jsonFactory, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Could not create Google Sheets client.", (Throwable)e);
        }
    }

    private Credential authorizeServiceAccount(CamelContext camelContext, String keyResource, String delegate, Collection<String> scopes) {
        try {
            GoogleCredential cred = GoogleCredential.fromStream((InputStream)ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)keyResource), (HttpTransport)this.transport, (JsonFactory)this.jsonFactory).createScoped(scopes != null && scopes.size() != 0 ? scopes : null).createDelegated(delegate);
            cred.refreshToken();
            return cred;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

