/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gora;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.gora.GoraAttribute;
import org.apache.camel.component.gora.GoraConfiguration;
import org.apache.camel.component.gora.GoraEndpoint;
import org.apache.camel.component.gora.GoraOperation;
import org.apache.camel.component.gora.utils.GoraUtils;
import org.apache.camel.support.DefaultProducer;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.store.DataStore;

public class GoraProducer
extends DefaultProducer {
    private final GoraConfiguration configuration;
    private final DataStore<Object, Persistent> dataStore;

    public GoraProducer(GoraEndpoint endpoint, GoraConfiguration configuration, DataStore<Object, Persistent> dataStore) {
        super((Endpoint)endpoint);
        this.dataStore = dataStore;
        this.configuration = configuration;
    }

    public void process(Exchange exchange) throws Exception {
        String operation = (String)exchange.getIn().getHeader(GoraAttribute.GORA_OPERATION.value);
        if (operation == null || operation.isEmpty()) {
            throw new RuntimeException("Gora operation is null or empty!");
        }
        Object result = 0;
        if (GoraOperation.PUT.value.equalsIgnoreCase(operation)) {
            this.dataStore.put(GoraUtils.getKeyFromExchange(exchange), GoraUtils.getValueFromExchange(exchange));
        } else if (GoraOperation.GET.value.equalsIgnoreCase(operation)) {
            result = this.dataStore.get(GoraUtils.getKeyFromExchange(exchange));
        } else if (GoraOperation.DELETE.value.equalsIgnoreCase(operation)) {
            result = this.dataStore.delete(GoraUtils.getKeyFromExchange(exchange));
        } else if (GoraOperation.QUERY.value.equalsIgnoreCase(operation)) {
            Map props = exchange.getIn().getHeaders();
            result = GoraUtils.constractQueryFromPropertiesMap(props, this.dataStore, this.configuration).execute();
        } else if (GoraOperation.DELETE_BY_QUERY.value.equalsIgnoreCase(operation)) {
            Map props = exchange.getIn().getHeaders();
            result = this.dataStore.deleteByQuery(GoraUtils.constractQueryFromPropertiesMap(props, this.dataStore, this.configuration));
        } else if (GoraOperation.GET_SCHEMA_NAME.value.equalsIgnoreCase(operation)) {
            result = this.dataStore.getSchemaName();
        } else if (GoraOperation.DELETE_SCHEMA.value.equalsIgnoreCase(operation)) {
            this.dataStore.deleteSchema();
        } else if (GoraOperation.CREATE_SCHEMA.value.equalsIgnoreCase(operation)) {
            this.dataStore.createSchema();
        } else if (GoraOperation.SCHEMA_EXIST.value.equalsIgnoreCase(operation)) {
            result = this.dataStore.schemaExists();
        } else {
            throw new RuntimeException("Unknown operation: " + operation);
        }
        if (this.configuration.isFlushOnEveryOperation()) {
            this.dataStore.flush();
        }
        exchange.getOut().setBody(result);
        exchange.getOut().setHeaders(exchange.getIn().getHeaders());
    }
}

