/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gora;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class GoraEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":name";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "gora".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "name", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(24);
        props.add("basicPropertyBinding");
        props.add("startKey");
        props.add("dataStoreClass");
        props.add("flushOnEveryOperation");
        props.add("synchronous");
        props.add("hadoopConfiguration");
        props.add("exchangePattern");
        props.add("keyClass");
        props.add("concurrentConsumers");
        props.add("timeRangeFrom");
        props.add("endKey");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("timeRangeTo");
        props.add("name");
        props.add("keyRangeFrom");
        props.add("limit");
        props.add("keyRangeTo");
        props.add("startTime");
        props.add("valueClass");
        props.add("endTime");
        props.add("fields");
        props.add("exceptionHandler");
        props.add("timestamp");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

